"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createManifest = void 0;
var _jsYaml = require("js-yaml");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createManifest = assetOptions => {
  const {
    format_version: formatVersion,
    name,
    title,
    description,
    version,
    owner,
    kibanaVersion
  } = assetOptions;
  const manifest = {
    format_version: formatVersion,
    name,
    title,
    description,
    version,
    owner,
    type: 'integration',
    conditions: {
      kibana: {
        version: kibanaVersion
      }
    }
  };
  return (0, _jsYaml.safeDump)(manifest);
};
exports.createManifest = createManifest;