"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createDatasetManifest = void 0;
var _jsYaml = require("js-yaml");
var _utils = require("../../utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createDatasetManifest = (dataset, assetOptions) => {
  const {
    format_version: formatVersion,
    type
  } = assetOptions;
  const manifest = {
    format_version: formatVersion,
    dataset,
    title: (0, _utils.convertStringToTitle)(dataset),
    type
  };
  return (0, _jsYaml.safeDump)(manifest);
};
exports.createDatasetManifest = createDatasetManifest;