"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isUserSettingsTemplate = exports.fillConstantKeywordValues = void 0;
var _constants = require("../../../../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const isUserSettingsTemplate = name => name.endsWith(_constants.USER_SETTINGS_TEMPLATE_SUFFIX);

// For any `constant_keyword` fields in `newMappings` that don't have a `value`, access the same field in
// the `oldMappings` and fill in the value from there
exports.isUserSettingsTemplate = isUserSettingsTemplate;
const fillConstantKeywordValues = (oldMappings, newMappings) => {
  const filledMappings = JSON.parse(JSON.stringify(newMappings));
  const deepGet = (obj, keys) => keys.reduce((xs, x) => {
    var _xs$x;
    return (_xs$x = xs === null || xs === void 0 ? void 0 : xs[x]) !== null && _xs$x !== void 0 ? _xs$x : undefined;
  }, obj);
  const fillEmptyConstantKeywordFields = (mappings, currentPath = []) => {
    if (!mappings) return;
    for (const [key, potentialField] of Object.entries(mappings)) {
      const path = [...currentPath, key];
      if (typeof potentialField === 'object') {
        if (potentialField.type === 'constant_keyword' && potentialField.value === undefined) {
          const valueFromOldMappings = deepGet(oldMappings.properties, [...path, 'value']);
          if (valueFromOldMappings !== undefined) {
            potentialField.value = valueFromOldMappings;
          }
        } else if (potentialField.properties && typeof potentialField.properties === 'object') {
          fillEmptyConstantKeywordFields(potentialField.properties, [...path, 'properties']);
        }
      }
    }
  };
  fillEmptyConstantKeywordFields(filledMappings.properties);
  return filledMappings;
};
exports.fillConstantKeywordValues = fillConstantKeywordValues;