"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.migratePackagePolicySetRequiresRootToV8150 = exports.migratePackagePolicyIdsToV8150 = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// backfill existing package policies with packages requiring root in 8.15.0
const ROOT_PACKAGES = ['endpoint', 'universal_profiling_agent', 'system_audit', 'network_traffic', 'fim', 'auditd_manager'];
const migratePackagePolicySetRequiresRootToV8150 = packagePolicyDoc => {
  const updatedPackagePolicyDoc = packagePolicyDoc;
  if (updatedPackagePolicyDoc.attributes.package && ROOT_PACKAGES.includes(updatedPackagePolicyDoc.attributes.package.name)) {
    updatedPackagePolicyDoc.attributes.package.requires_root = true;
  }
  return {
    attributes: updatedPackagePolicyDoc.attributes
  };
};
exports.migratePackagePolicySetRequiresRootToV8150 = migratePackagePolicySetRequiresRootToV8150;
const migratePackagePolicyIdsToV8150 = packagePolicyDoc => {
  const updatedPackagePolicyDoc = packagePolicyDoc;
  if (updatedPackagePolicyDoc.attributes.policy_id) {
    updatedPackagePolicyDoc.attributes.policy_ids = [updatedPackagePolicyDoc.attributes.policy_id];
  }
  return {
    attributes: updatedPackagePolicyDoc.attributes
  };
};
exports.migratePackagePolicyIdsToV8150 = migratePackagePolicyIdsToV8150;