"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.processorsFormatter = exports.migrateSyntheticsPackagePolicyToV8100 = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const migrateSyntheticsPackagePolicyToV8100 = packagePolicyDoc => {
  var _packagePolicyDoc$att;
  if (((_packagePolicyDoc$att = packagePolicyDoc.attributes.package) === null || _packagePolicyDoc$att === void 0 ? void 0 : _packagePolicyDoc$att.name) !== 'synthetics' || !packagePolicyDoc.attributes.is_managed) {
    return packagePolicyDoc;
  }
  const updatedAttributes = packagePolicyDoc.attributes;
  const enabledInput = updatedAttributes.inputs.find(input => input.enabled === true);
  const enabledStream = enabledInput === null || enabledInput === void 0 ? void 0 : enabledInput.streams.find(stream => {
    return ['browser', 'http', 'icmp', 'tcp'].includes(stream.data_stream.dataset);
  });
  if (!enabledStream) {
    return {
      attributes: updatedAttributes
    };
  }
  if (enabledStream.vars) {
    const processors = processorsFormatter(enabledStream.vars);
    enabledStream.vars.processors = {
      value: processors,
      type: 'yaml'
    };
    enabledStream.compiled_stream.processors = processors;
  }
  return {
    attributes: updatedAttributes
  };
};
exports.migrateSyntheticsPackagePolicyToV8100 = migrateSyntheticsPackagePolicyToV8100;
const processorsFormatter = vars => {
  var _vars$test_run_id, _vars$run_once, _vars$config_id, _vars$monitorProject, _vars$monitorProject2, _vars$monitorId;
  const fields = {
    'monitor.fleet_managed': true
  };
  if ((_vars$test_run_id = vars.test_run_id) !== null && _vars$test_run_id !== void 0 && _vars$test_run_id.value) {
    fields.test_run_id = vars.test_run_id.value;
  }
  if ((_vars$run_once = vars.run_once) !== null && _vars$run_once !== void 0 && _vars$run_once.value) {
    fields.run_once = vars.run_once.value;
  }
  if ((_vars$config_id = vars.config_id) !== null && _vars$config_id !== void 0 && _vars$config_id.value) {
    fields.config_id = vars.config_id.value;
  }
  const projName = (_vars$monitorProject = vars['monitor.project.name']) === null || _vars$monitorProject === void 0 ? void 0 : _vars$monitorProject.value;
  if (projName) {
    fields['monitor.project.name'] = projName;
  }
  const projId = (_vars$monitorProject2 = vars['monitor.project.id']) === null || _vars$monitorProject2 === void 0 ? void 0 : _vars$monitorProject2.value;
  if (projId) {
    fields['monitor.project.id'] = projId;
  }
  const monId = (_vars$monitorId = vars['monitor.id']) === null || _vars$monitorId === void 0 ? void 0 : _vars$monitorId.value;
  if (monId) {
    fields['monitor.id'] = monId;
  }
  const processors = [{
    add_fields: {
      fields,
      target: ''
    }
  }];
  return JSON.stringify(processors);
};
exports.processorsFormatter = processorsFormatter;