"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getUninstallTokensMetadataHandler = exports.getUninstallTokenHandler = void 0;
var _services = require("../../services");
var _constants = require("../../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getUninstallTokensMetadataHandler = async (context, request, response) => {
  const [fleetContext, coreContext] = await Promise.all([context.fleet, context.core]);
  const uninstallTokenService = fleetContext.uninstallTokenService.asCurrentUser;
  const {
    page = 1,
    perPage = 20,
    policyId,
    search
  } = request.query;
  if (policyId && search) {
    return response.badRequest({
      body: {
        message: 'Query parameters `policyId` and `search` cannot be used at the same time.'
      }
    });
  }
  const soClient = coreContext.savedObjects.client;
  const {
    items: managedPolicies
  } = await _services.agentPolicyService.list(soClient, {
    fields: ['id'],
    perPage: _constants.SO_SEARCH_LIMIT,
    kuery: `${_constants.LEGACY_AGENT_POLICY_SAVED_OBJECT_TYPE}.is_managed:true`
  });
  const managedPolicyIds = managedPolicies.map(policy => policy.id);
  let policyIdSearchTerm;
  let policyNameSearchTerm;
  if (search) {
    policyIdSearchTerm = search.trim();
    policyNameSearchTerm = search.trim();
  } else if (policyId) {
    policyIdSearchTerm = policyId.trim();
  }
  const body = await uninstallTokenService.getTokenMetadata(policyIdSearchTerm, policyNameSearchTerm, page, perPage, managedPolicyIds.length > 0 ? managedPolicyIds : undefined);
  return response.ok({
    body
  });
};
exports.getUninstallTokensMetadataHandler = getUninstallTokensMetadataHandler;
const getUninstallTokenHandler = async (context, request, response) => {
  const [fleetContext] = await Promise.all([context.fleet, context.core]);
  const uninstallTokenService = fleetContext.uninstallTokenService.asCurrentUser;
  const {
    uninstallTokenId
  } = request.params;
  const token = await uninstallTokenService.getToken(uninstallTokenId);
  if (token === null) {
    return response.notFound({
      body: {
        message: `Uninstall Token not found with id ${uninstallTokenId}`
      }
    });
  }
  const body = {
    item: token
  };
  return response.ok({
    body
  });
};
exports.getUninstallTokenHandler = getUninstallTokenHandler;