"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AgentPolicySummaryLine = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireWildcard(require("react"));
var _hooks = require("../hooks");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MIN_WIDTH = {
  minWidth: 0
};
const NO_WRAP_WHITE_SPACE = {
  whiteSpace: 'nowrap'
};
const WRAP_WHITE_SPACE = {
  whiteSpace: 'normal'
};
const AgentPolicySummaryLine = exports.AgentPolicySummaryLine = /*#__PURE__*/(0, _react.memo)(({
  policy,
  agent,
  direction = 'row',
  withDescription = false
}) => {
  const {
    getHref
  } = (0, _hooks.useLink)();
  const {
    name,
    id,
    is_managed: isManaged,
    description
  } = policy;
  const revision = agent ? agent.policy_revision : policy.revision;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "xs",
    wrap: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: direction,
    gutterSize: direction === 'column' ? 'none' : 's',
    alignItems: "baseline",
    style: MIN_WIDTH,
    responsive: false,
    justifyContent: 'flexStart'
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    style: MIN_WIDTH,
    gutterSize: "s",
    alignItems: "baseline",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    style: WRAP_WHITE_SPACE,
    href: getHref('policy_details', {
      policyId: id
    }),
    title: name || id,
    "data-test-subj": "agentPolicyNameLink"
  }, name || id)), isManaged && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
    title: "Hosted agent policy",
    content: _i18n.i18n.translate('xpack.fleet.agentPolicySummaryLine.hostedPolicyTooltip', {
      defaultMessage: 'This policy is managed outside of Fleet. Most actions related to this policy are unavailable.'
    }),
    type: "lock",
    size: "m",
    color: "subdued"
  })))), revision && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "xs",
    style: NO_WRAP_WHITE_SPACE
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentPolicySummaryLine.revisionNumber",
    defaultMessage: "rev. {revNumber}",
    values: {
      revNumber: revision
    }
  }))))), withDescription && description && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    title: description,
    size: "xs"
  }, description)));
});