"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ChangelogModal = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _hooks = require("../../../../../hooks");
var _utils = require("../utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ChangelogModal = ({
  latestVersion,
  currentVersion,
  packageName,
  onClose
}) => {
  const {
    notifications
  } = (0, _hooks.useStartServices)();
  const {
    data: changelogResponse,
    error: changelogError,
    isLoading
  } = (0, _hooks.useGetFileByPathQuery)(`/package/${packageName}/${latestVersion}/changelog.yml`);
  const changelogText = changelogResponse === null || changelogResponse === void 0 ? void 0 : changelogResponse.data;

  // currentVersion is used to display the changelog up to the current installed version, when there is a newer one available
  const finalChangelog = currentVersion ? (0, _utils.getFormattedChangelog)(changelogText, latestVersion, currentVersion) : (0, _utils.getFormattedChangelog)(changelogText, latestVersion);
  if (changelogError) {
    notifications.toasts.addError(changelogError, {
      title: _i18n.i18n.translate('xpack.fleet.epm.errorLoadingChangelog', {
        defaultMessage: 'Error loading changelog information'
      })
    });
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiModal, {
    maxWidth: true,
    onClose: onClose,
    "data-test-subj": "integrations.changelogModal"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeader, null, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeaderTitle, null, 'Changelog')), /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
    lines: 10,
    size: "s",
    isLoading: isLoading,
    contentAriaLabel: "changelog text"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    overflowHeight: 360
  }, finalChangelog))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    color: "primary",
    fill: true,
    onClick: onClose
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.epm.changelogModalCloseBtn",
    defaultMessage: "Close"
  }))));
};
exports.ChangelogModal = ChangelogModal;