"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AssetsAccordion = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _constants = require("../../../constants");
var _hooks = require("../../../../../hooks");
var _types = require("../../../../../types");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AssetsAccordion = ({
  savedObjects,
  type
}) => {
  const {
    http
  } = (0, _hooks.useStartServices)();
  const isDashboard = type === _types.KibanaAssetType.dashboard;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    initialIsOpen: isDashboard,
    "data-test-subj": `fleetAssetsAccordion.button.${type}`,
    buttonContent: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: "center",
      alignItems: "center",
      gutterSize: "s",
      responsive: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "m"
    }, /*#__PURE__*/_react.default.createElement("h3", null, _constants.AssetTitleMap[type]))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiNotificationBadge, {
      color: "subdued",
      size: "m"
    }, /*#__PURE__*/_react.default.createElement("h3", null, savedObjects.length)))),
    id: type
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSplitPanel.Outer, {
    hasBorder: true,
    hasShadow: false,
    "data-test-subj": `fleetAssetsAccordion.content.${type}`
  }, savedObjects.map(({
    id,
    attributes,
    appLink
  }, idx) => {
    const {
      title: soTitle,
      description
    } = attributes || {};
    // Ignore custom asset views or if not a Kibana asset
    if (type === 'view') {
      return;
    }
    const title = soTitle !== null && soTitle !== void 0 ? soTitle : id;
    return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
      key: id
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiSplitPanel.Inner, {
      grow: false,
      key: idx,
      "data-test-subj": `fleetAssetsAccordion.content.${type}.${title}`
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "m"
    }, /*#__PURE__*/_react.default.createElement("p", null, appLink ? /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      href: http.basePath.prepend(appLink)
    }, title) : title)), description && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      color: "subdued"
    }, /*#__PURE__*/_react.default.createElement("p", null, description)))), idx + 1 < savedObjects.length && /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
      margin: "none"
    }));
  }))));
};
exports.AssetsAccordion = AssetsAccordion;