"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DefaultOutputBadge = exports.DefaultMonitoringOutputBadge = exports.DefaultBadges = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DefaultBadges = exports.DefaultBadges = /*#__PURE__*/_react.default.memo(({
  output
}) => {
  const badges = (0, _react.useMemo)(() => {
    const badgesArray = [];
    if (output.is_default) {
      badgesArray.push( /*#__PURE__*/_react.default.createElement(DefaultOutputBadge, {
        key: "default-output"
      }));
    }
    if (output.is_default_monitoring) {
      badgesArray.push( /*#__PURE__*/_react.default.createElement(DefaultMonitoringOutputBadge, {
        key: "default-monitoring-output"
      }));
    }
    return badgesArray;
  }, [output]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiBadgeGroup, {
    gutterSize: "xs"
  }, badges.map((badge, idx) => badge));
});
const DefaultOutputBadge = () => /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.fleet.settings.outputs.defaultOutputBadgeTitle",
  defaultMessage: "Agent integrations"
}));
exports.DefaultOutputBadge = DefaultOutputBadge;
const DefaultMonitoringOutputBadge = () => /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.fleet.settings.outputs.defaultMonitoringOutputBadgeTitle",
  defaultMessage: "Agent monitoring"
}));
exports.DefaultMonitoringOutputBadge = DefaultMonitoringOutputBadge;