"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StepEditHosts = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _components = require("../../components");
var _services = require("../../../../services");
var _step_select_agent_policy = require("../../create_package_policy_page/components/steps/step_select_agent_policy");
var _components2 = require("../../create_package_policy_page/components");
var _use_policies = require("../../create_package_policy_page/components/steps/components/use_policies");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const StepEditHosts = ({
  agentPolicies,
  updateAgentPolicies,
  newAgentPolicy,
  updateNewAgentPolicy,
  withSysMonitoring,
  updateSysMonitoring,
  validation,
  packageInfo,
  setHasAgentPolicyError,
  selectedAgentPolicyIds,
  updateSelectedTab
}) => {
  const [showCreateAgentPolicy, setShowCreateAgentPolicy] = (0, _react.useState)(false);
  const existingAgentPolicies = (0, _use_policies.useAllNonManagedAgentPolicies)();
  (0, _react.useEffect)(() => {
    if (existingAgentPolicies.length > 0) {
      updateNewAgentPolicy({
        ...newAgentPolicy,
        name: (0, _services.incrementPolicyName)(existingAgentPolicies)
      });
    }
  }, [existingAgentPolicies.length]); // eslint-disable-line react-hooks/exhaustive-deps

  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    alignItems: "flexStart"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.editPackagePolicy.stepEditAgentPoliciesTitle",
    defaultMessage: "For existing hosts:"
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_step_select_agent_policy.StepSelectAgentPolicy, {
    packageInfo: packageInfo,
    agentPolicies: agentPolicies,
    updateAgentPolicies: updateAgentPolicies,
    setHasAgentPolicyError: setHasAgentPolicyError,
    initialSelectedAgentPolicyIds: selectedAgentPolicyIds
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.editPackagePolicy.stepAddAgentPolicyTitle",
    defaultMessage: "For a new host:"
  })))), !showCreateAgentPolicy && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    iconType: "plusInCircle",
    onClick: () => {
      setShowCreateAgentPolicy(true);
      updateSelectedTab(_components2.SelectedPolicyTab.NEW);
    },
    "data-test-subj": "createNewAgentPolicyButton"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.editPackagePolicy.addNewAgentPolicyButtonText",
    defaultMessage: "Create a new agent policy"
  }))), showCreateAgentPolicy && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_components.AgentPolicyIntegrationForm, {
    agentPolicy: newAgentPolicy,
    updateAgentPolicy: updateNewAgentPolicy,
    withSysMonitoring: withSysMonitoring,
    updateSysMonitoring: updateSysMonitoring,
    validation: validation
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    iconType: "trash",
    color: "text",
    onClick: () => {
      setShowCreateAgentPolicy(false);
      updateSelectedTab(_components2.SelectedPolicyTab.EXISTING);
    },
    "data-test-subj": "deleteNewAgentPolicyButton"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.editPackagePolicy.removeNewAgentPolicyButtonText",
    defaultMessage: "Remove"
  })))));
};
exports.StepEditHosts = StepEditHosts;