"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HeaderRightContent = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _reactRouterDom = require("react-router-dom");
var _eui = require("@elastic/eui");
var _hooks = require("../../../../../hooks");
var _components = require("../../../components");
var _components2 = require("../../../../../components");
var _constants = require("../../../../../../../../common/constants");
var _services = require("../../../../../../../../common/services");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const Divider = _styledComponents.default.div`
  width: 0;
  height: 100%;
  border-left: ${props => props.theme.eui.euiBorderThin};
`;
const HeaderRightContent = ({
  isLoading,
  agentPolicy,
  addAgent,
  onCancelEnrollment,
  isAddAgentHelpPopoverOpen,
  setIsAddAgentHelpPopoverOpen
}) => {
  var _agentPolicy$revision;
  const authz = (0, _hooks.useAuthz)();
  const {
    getPath
  } = (0, _hooks.useLink)();
  const history = (0, _reactRouterDom.useHistory)();
  const isFleetServerPolicy = (0, _react.useMemo)(() => {
    var _agentPolicy$package_;
    return agentPolicy === null || agentPolicy === void 0 ? void 0 : (_agentPolicy$package_ = agentPolicy.package_policies) === null || _agentPolicy$package_ === void 0 ? void 0 : _agentPolicy$package_.some(packagePolicy => {
      var _packagePolicy$packag;
      return ((_packagePolicy$packag = packagePolicy.package) === null || _packagePolicy$packag === void 0 ? void 0 : _packagePolicy$packag.name) === _constants.FLEET_SERVER_PACKAGE;
    });
  }, [agentPolicy]);
  if (!agentPolicy) {
    return null;
  }
  const addFleetServerLink = /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    onClick: addAgent,
    "data-test-subj": "addAgentLink"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.policyDetails.addFleetServerButton",
    defaultMessage: "Add Fleet Server"
  }));
  const addAgentLink = /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    onClick: addAgent,
    "data-test-subj": "addAgentLink"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.policyDetails.addAgentButton",
    defaultMessage: "Add agent"
  }));
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: 'flexEnd',
    direction: "row"
  }, isLoading || !agentPolicy ? null : [{
    label: _i18n.i18n.translate('xpack.fleet.policyDetails.summary.revision', {
      defaultMessage: 'Revision'
    }),
    content: (_agentPolicy$revision = agentPolicy.revision) !== null && _agentPolicy$revision !== void 0 ? _agentPolicy$revision : 0
  }, {
    isDivider: true
  }, {
    label: _i18n.i18n.translate('xpack.fleet.policyDetails.summary.integrations', {
      defaultMessage: 'Integrations'
    }),
    content: /*#__PURE__*/_react.default.createElement(_eui.EuiI18nNumber, {
      value: agentPolicy.package_policies && agentPolicy.package_policies.length || 0
    })
  }, {
    isDivider: true
  }, ...(authz.fleet.readAgents && !(agentPolicy !== null && agentPolicy !== void 0 && agentPolicy.supports_agentless) ? [{
    label: _i18n.i18n.translate('xpack.fleet.policyDetails.summary.usedBy', {
      defaultMessage: 'Agents'
    }),
    content: !agentPolicy.agents && isFleetServerPolicy && authz.fleet.addFleetServers ? /*#__PURE__*/_react.default.createElement(_components2.AddAgentHelpPopover, {
      button: addFleetServerLink,
      isOpen: isAddAgentHelpPopoverOpen,
      offset: 15,
      closePopover: () => {
        setIsAddAgentHelpPopoverOpen(false);
      }
    }) : !agentPolicy.agents && !isFleetServerPolicy && authz.fleet.addAgents ? /*#__PURE__*/_react.default.createElement(_components2.AddAgentHelpPopover, {
      button: addAgentLink,
      isOpen: isAddAgentHelpPopoverOpen,
      offset: 15,
      closePopover: () => {
        setIsAddAgentHelpPopoverOpen(false);
      }
    }) : /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      direction: "row",
      gutterSize: "xs",
      alignItems: "center"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        direction: "column",
        gutterSize: "xs"
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.policyDetails.summary.usedByUnprivilegedTooltip",
        defaultMessage: "{count, plural, one {# unprivileged agent} other {# unprivileged agents}}",
        values: {
          count: agentPolicy.unprivileged_agents || 0
        }
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.policyDetails.summary.usedByPrivilegedTooltip",
        defaultMessage: "{count, plural, one {# privileged agent} other {# privileged agents}}",
        values: {
          count: (agentPolicy.agents || 0) - (agentPolicy.unprivileged_agents || 0)
        }
      })))
    }, /*#__PURE__*/_react.default.createElement(_components.LinkedAgentCount, {
      count: agentPolicy.agents || 0,
      agentPolicyId: agentPolicy.id,
      showAgentText: true
    }))), (0, _services.getRootIntegrations)(agentPolicy.package_policies || []).length > 0 && (agentPolicy.unprivileged_agents || 0) > 0 && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
      type: "warning",
      color: "warning",
      content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.policyDetails.summary.containsUnprivilegedAgentsWarning",
        defaultMessage: "This agent policy contains integrations that require Elastic Agents to have root privileges. Some enrolled agents are running in unprivileged mode."
      })
    })))
  }, {
    isDivider: true
  }] : []), {
    label: _i18n.i18n.translate('xpack.fleet.policyDetails.summary.lastUpdated', {
      defaultMessage: 'Last updated on'
    }),
    content: agentPolicy && /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedDate, {
      value: agentPolicy === null || agentPolicy === void 0 ? void 0 : agentPolicy.updated_at,
      year: "numeric",
      month: "short",
      day: "2-digit"
    }) || ''
  }, {
    isDivider: true
  }, {
    content: agentPolicy && /*#__PURE__*/_react.default.createElement(_components.AgentPolicyActionMenu, {
      agentPolicy: agentPolicy,
      fullButton: true,
      onCopySuccess: newAgentPolicy => {
        history.push(getPath('policy_details', {
          policyId: newAgentPolicy.id
        }));
      },
      onCancelEnrollment: onCancelEnrollment
    })
  }].map((item, index) => {
    var _item$isDivider;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      key: index
    }, ((_item$isDivider = item.isDivider) !== null && _item$isDivider !== void 0 ? _item$isDivider : false) ? /*#__PURE__*/_react.default.createElement(Divider, null) : item.label ? /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
      compressed: true,
      textStyle: "reverse",
      style: {
        textAlign: 'right'
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, {
      className: "eui-textNoWrap"
    }, item.label), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, {
      className: "eui-textNoWrap"
    }, item.content)) : item.content);
  }));
};
exports.HeaderRightContent = HeaderRightContent;