"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RegistryVarsEntryKeys = exports.RegistryStreamKeys = exports.RegistryPolicyTemplateKeys = exports.RegistryInputKeys = exports.RegistryDataStreamKeys = exports.KibanaSavedObjectType = exports.KibanaAssetType = exports.InstallStatus = exports.INSTALL_STATES = exports.ElasticsearchAssetType = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
let InstallStatus = exports.InstallStatus = /*#__PURE__*/function (InstallStatus) {
  InstallStatus["installed"] = "installed";
  InstallStatus["notInstalled"] = "not_installed";
  InstallStatus["installing"] = "installing";
  InstallStatus["reinstalling"] = "reinstalling";
  InstallStatus["uninstalling"] = "uninstalling";
  return InstallStatus;
}({});
/*
  Enum mapping of a saved object asset type to how it would appear in a package file path (snake cased)
*/
let KibanaAssetType = exports.KibanaAssetType = /*#__PURE__*/function (KibanaAssetType) {
  KibanaAssetType["dashboard"] = "dashboard";
  KibanaAssetType["lens"] = "lens";
  KibanaAssetType["visualization"] = "visualization";
  KibanaAssetType["search"] = "search";
  KibanaAssetType["indexPattern"] = "index_pattern";
  KibanaAssetType["map"] = "map";
  KibanaAssetType["mlModule"] = "ml_module";
  KibanaAssetType["securityAIPrompt"] = "security_ai_prompt";
  KibanaAssetType["securityRule"] = "security_rule";
  KibanaAssetType["cloudSecurityPostureRuleTemplate"] = "csp_rule_template";
  KibanaAssetType["osqueryPackAsset"] = "osquery_pack_asset";
  KibanaAssetType["osquerySavedQuery"] = "osquery_saved_query";
  KibanaAssetType["tag"] = "tag";
  return KibanaAssetType;
}({});
/*
 Enum of saved object types that are allowed to be installed
*/
let KibanaSavedObjectType = exports.KibanaSavedObjectType = /*#__PURE__*/function (KibanaSavedObjectType) {
  KibanaSavedObjectType["dashboard"] = "dashboard";
  KibanaSavedObjectType["lens"] = "lens";
  KibanaSavedObjectType["visualization"] = "visualization";
  KibanaSavedObjectType["search"] = "search";
  KibanaSavedObjectType["indexPattern"] = "index-pattern";
  KibanaSavedObjectType["map"] = "map";
  KibanaSavedObjectType["mlModule"] = "ml-module";
  KibanaSavedObjectType["securityAIPrompt"] = "security-ai-prompt";
  KibanaSavedObjectType["securityRule"] = "security-rule";
  KibanaSavedObjectType["cloudSecurityPostureRuleTemplate"] = "csp-rule-template";
  KibanaSavedObjectType["osqueryPackAsset"] = "osquery-pack-asset";
  KibanaSavedObjectType["osquerySavedQuery"] = "osquery-saved-query";
  KibanaSavedObjectType["tag"] = "tag";
  return KibanaSavedObjectType;
}({});
let ElasticsearchAssetType = exports.ElasticsearchAssetType = /*#__PURE__*/function (ElasticsearchAssetType) {
  ElasticsearchAssetType["index"] = "index";
  ElasticsearchAssetType["indexTemplate"] = "index_template";
  ElasticsearchAssetType["componentTemplate"] = "component_template";
  ElasticsearchAssetType["ingestPipeline"] = "ingest_pipeline";
  ElasticsearchAssetType["ilmPolicy"] = "ilm_policy";
  ElasticsearchAssetType["dataStreamIlmPolicy"] = "data_stream_ilm_policy";
  ElasticsearchAssetType["transform"] = "transform";
  ElasticsearchAssetType["mlModel"] = "ml_model";
  return ElasticsearchAssetType;
}({}); // Defined as part of the removing public references to saved object schemas
// Registry packages do have extra fields.
// cf. type Package struct at https://github.com/elastic/package-registry/blob/master/util/package.go
// our current types have `download`, & `path` as required but they're are optional (have `omitempty`) according to
// https://github.com/elastic/package-registry/blob/master/util/package.go#L57
// & https://github.com/elastic/package-registry/blob/master/util/package.go#L80-L81
// However, they are always present in every registry response I checked. Chose to keep types unchanged for now
// and confirm with Registry if they are really optional. Can update types and ~4 places in code later if neccessary
let RegistryPolicyTemplateKeys = exports.RegistryPolicyTemplateKeys = /*#__PURE__*/function (RegistryPolicyTemplateKeys) {
  RegistryPolicyTemplateKeys["categories"] = "categories";
  RegistryPolicyTemplateKeys["data_streams"] = "data_streams";
  RegistryPolicyTemplateKeys["inputs"] = "inputs";
  RegistryPolicyTemplateKeys["readme"] = "readme";
  RegistryPolicyTemplateKeys["multiple"] = "multiple";
  RegistryPolicyTemplateKeys["type"] = "type";
  RegistryPolicyTemplateKeys["required_vars"] = "required_vars";
  RegistryPolicyTemplateKeys["vars"] = "vars";
  RegistryPolicyTemplateKeys["input"] = "input";
  RegistryPolicyTemplateKeys["template_path"] = "template_path";
  RegistryPolicyTemplateKeys["name"] = "name";
  RegistryPolicyTemplateKeys["title"] = "title";
  RegistryPolicyTemplateKeys["description"] = "description";
  RegistryPolicyTemplateKeys["icons"] = "icons";
  RegistryPolicyTemplateKeys["screenshots"] = "screenshots";
  RegistryPolicyTemplateKeys["deployment_modes"] = "deployment_modes";
  RegistryPolicyTemplateKeys["configuration_links"] = "configuration_links";
  return RegistryPolicyTemplateKeys;
}({});
let RegistryInputKeys = exports.RegistryInputKeys = /*#__PURE__*/function (RegistryInputKeys) {
  RegistryInputKeys["type"] = "type";
  RegistryInputKeys["title"] = "title";
  RegistryInputKeys["description"] = "description";
  RegistryInputKeys["template_path"] = "template_path";
  RegistryInputKeys["condition"] = "condition";
  RegistryInputKeys["input_group"] = "input_group";
  RegistryInputKeys["required_vars"] = "required_vars";
  RegistryInputKeys["vars"] = "vars";
  return RegistryInputKeys;
}({});
let RegistryStreamKeys = exports.RegistryStreamKeys = /*#__PURE__*/function (RegistryStreamKeys) {
  RegistryStreamKeys["input"] = "input";
  RegistryStreamKeys["title"] = "title";
  RegistryStreamKeys["description"] = "description";
  RegistryStreamKeys["enabled"] = "enabled";
  RegistryStreamKeys["required_vars"] = "required_vars";
  RegistryStreamKeys["vars"] = "vars";
  RegistryStreamKeys["template_path"] = "template_path";
  return RegistryStreamKeys;
}({}); // Registry's response types
// from /search
// https://github.com/elastic/package-registry/blob/master/docs/api/search.json
// from getPackageOutput at https://github.com/elastic/package-registry/blob/master/search.go
// from /categories
// https://github.com/elastic/package-registry/blob/master/docs/api/categories.json
let RegistryDataStreamKeys = exports.RegistryDataStreamKeys = /*#__PURE__*/function (RegistryDataStreamKeys) {
  RegistryDataStreamKeys["type"] = "type";
  RegistryDataStreamKeys["ilm_policy"] = "ilm_policy";
  RegistryDataStreamKeys["hidden"] = "hidden";
  RegistryDataStreamKeys["dataset"] = "dataset";
  RegistryDataStreamKeys["title"] = "title";
  RegistryDataStreamKeys["release"] = "release";
  RegistryDataStreamKeys["streams"] = "streams";
  RegistryDataStreamKeys["package"] = "package";
  RegistryDataStreamKeys["path"] = "path";
  RegistryDataStreamKeys["ingest_pipeline"] = "ingest_pipeline";
  RegistryDataStreamKeys["elasticsearch"] = "elasticsearch";
  RegistryDataStreamKeys["dataset_is_prefix"] = "dataset_is_prefix";
  RegistryDataStreamKeys["routing_rules"] = "routing_rules";
  RegistryDataStreamKeys["lifecycle"] = "lifecycle";
  RegistryDataStreamKeys["agent"] = "agent";
  return RegistryDataStreamKeys;
}({});
let RegistryVarsEntryKeys = exports.RegistryVarsEntryKeys = /*#__PURE__*/function (RegistryVarsEntryKeys) {
  RegistryVarsEntryKeys["name"] = "name";
  RegistryVarsEntryKeys["title"] = "title";
  RegistryVarsEntryKeys["description"] = "description";
  RegistryVarsEntryKeys["type"] = "type";
  RegistryVarsEntryKeys["required"] = "required";
  RegistryVarsEntryKeys["show_user"] = "show_user";
  RegistryVarsEntryKeys["multi"] = "multi";
  RegistryVarsEntryKeys["options"] = "options";
  RegistryVarsEntryKeys["default"] = "default";
  RegistryVarsEntryKeys["os"] = "os";
  RegistryVarsEntryKeys["secret"] = "secret";
  RegistryVarsEntryKeys["hide_in_deployment_modes"] = "hide_in_deployment_modes";
  RegistryVarsEntryKeys["full_width"] = "full_width";
  return RegistryVarsEntryKeys;
}({}); // EPR types this as `[]map[string]interface{}`
// which means the official/possible type is Record<string, any>
// but we effectively only see this shape
// Deprecated as part of the removing public references to saved object schemas
// See https://github.com/elastic/kibana/issues/149098
/**
 * @deprecated replaced with installationInfo
 */
// Deprecated as part of the removing public references to saved object schemas
// See https://github.com/elastic/kibana/issues/149098
/**
 * @deprecated
 */
// some properties are optional in Registry responses but required in EPM
// internal until we need them
// Managers public HTTP response types
// Remove savedObject when addressing the deprecation
// TODO - Expand this with other experimental indexing types
let INSTALL_STATES = exports.INSTALL_STATES = /*#__PURE__*/function (INSTALL_STATES) {
  INSTALL_STATES["CREATE_RESTART_INSTALLATION"] = "create_restart_installation";
  INSTALL_STATES["INSTALL_KIBANA_ASSETS"] = "install_kibana_assets";
  INSTALL_STATES["INSTALL_ILM_POLICIES"] = "install_ilm_policies";
  INSTALL_STATES["INSTALL_ML_MODEL"] = "install_ml_model";
  INSTALL_STATES["INSTALL_INDEX_TEMPLATE_PIPELINES"] = "install_index_template_pipelines";
  INSTALL_STATES["REMOVE_LEGACY_TEMPLATES"] = "remove_legacy_templates";
  INSTALL_STATES["UPDATE_CURRENT_WRITE_INDICES"] = "update_current_write_indices";
  INSTALL_STATES["INSTALL_TRANSFORMS"] = "install_transforms";
  INSTALL_STATES["DELETE_PREVIOUS_PIPELINES"] = "delete_previous_pipelines";
  INSTALL_STATES["SAVE_ARCHIVE_ENTRIES"] = "save_archive_entries_from_assets_map";
  INSTALL_STATES["RESOLVE_KIBANA_PROMISE"] = "resolve_kibana_promise";
  INSTALL_STATES["UPDATE_SO"] = "update_so";
  return INSTALL_STATES;
}({}); // This is an index template v2, see https://github.com/elastic/elasticsearch/issues/53101
// until "proper" documentation of the new format is available.
// Fleet does not use nor support the legacy index template v1 format at all