"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.zodStringWithDurationValidation = exports.AGENT_POLICY_ADVANCED_SETTINGS = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _zod = require("@kbn/zod");
var _constants = require("../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const zodStringWithDurationValidation = exports.zodStringWithDurationValidation = _zod.z.string().refine(val => val.match(/^(\d+[s|m|h|d])?$/), {
  message: _i18n.i18n.translate('xpack.fleet.settings.agentPolicyAdvanced.downloadTimeoutValidationMessage', {
    defaultMessage: 'Must be a string with a time unit, e.g. 30s, 5m, 2h, 1d'
  })
});
const AGENT_POLICY_ADVANCED_SETTINGS = exports.AGENT_POLICY_ADVANCED_SETTINGS = [{
  name: 'agent.limits.go_max_procs',
  title: _i18n.i18n.translate('xpack.fleet.settings.agentPolicyAdvanced.goMaxProcsTitle', {
    defaultMessage: 'Limit CPU usage'
  }),
  description: _i18n.i18n.translate('xpack.fleet.settings.agentPolicyAdvanced.goMaxProcsDescription', {
    defaultMessage: 'Limits the maximum number of CPUs that can be executing simultaneously.'
  }),
  learnMoreLink: 'https://www.elastic.co/guide/en/fleet/current/agent-policy.html#agent-policy-limit-cpu',
  api_field: {
    name: 'agent_limits_go_max_procs'
  },
  schema: _zod.z.number().int().min(0)
}, {
  name: 'agent.download.timeout',
  hidden: true,
  title: _i18n.i18n.translate('xpack.fleet.settings.agentPolicyAdvanced.downloadTimeoutTitle', {
    defaultMessage: 'Agent binary download timeout'
  }),
  description: _i18n.i18n.translate('xpack.fleet.settings.agentPolicyAdvanced.downloadTimeoutDescription', {
    defaultMessage: 'Timeout for downloading the agent binary.'
  }),
  learnMoreLink: 'https://www.elastic.co/guide/en/fleet/current/enable-custom-policy-settings.html#configure-agent-download-timeout',
  api_field: {
    name: 'agent_download_timeout'
  },
  schema: zodStringWithDurationValidation
}, {
  name: 'agent.download.target_directory',
  hidden: true,
  api_field: {
    name: 'agent_download_target_directory'
  },
  title: _i18n.i18n.translate('xpack.fleet.settings.agentPolicyAdvanced.agentDownloadTargetDirectoryTitle', {
    defaultMessage: 'Agent binary target directory'
  }),
  description: _i18n.i18n.translate('xpack.fleet.settings.agentPolicyAdvanced.agentDownloadTargetDirectoryDescription', {
    defaultMessage: 'The disk path to which the agent binary will be downloaded.'
  }),
  learnMoreLink: 'https://www.elastic.co/guide/en/fleet/current/elastic-agent-standalone-download.html',
  schema: _zod.z.string()
}, {
  name: 'agent.logging.metrics.period',
  hidden: true,
  api_field: {
    name: 'agent_logging_metrics_period'
  },
  title: _i18n.i18n.translate('xpack.fleet.settings.agentPolicyAdvanced.agentLoggingMetricsPeriodTitle', {
    defaultMessage: 'Agent logging metrics period'
  }),
  description: _i18n.i18n.translate('xpack.fleet.settings.agentPolicyAdvanced.agentLoggingMetricsPeriodDescription', {
    defaultMessage: 'The frequency of logging the internal Elastic Agent metrics.'
  }),
  learnMoreLink: 'https://www.elastic.co/guide/en/fleet/current/elastic-agent-standalone-logging-config.html#elastic-agent-standalone-logging-settings',
  schema: zodStringWithDurationValidation
}, {
  name: 'agent.logging.level',
  title: _i18n.i18n.translate('xpack.fleet.settings.agentPolicyAdvanced.agentLoggingLevelTitle', {
    defaultMessage: 'Agent logging level'
  }),
  description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.settings.agentPolicyAdvanced.agentLoggingLevelDescription",
    defaultMessage: "Sets the log level for all the agents on the policy. The default log level is {level}.",
    values: {
      level: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, _constants.DEFAULT_LOG_LEVEL)
    }
  }),
  api_field: {
    name: 'agent_logging_level'
  },
  learnMoreLink: 'https://www.elastic.co/guide/en/fleet/current/agent-policy.html#agent-policy-log-level',
  schema: _zod.z.enum(_constants.AGENT_LOG_LEVELS).default(_constants.DEFAULT_LOG_LEVEL)
}, {
  name: 'agent.logging.to_files',
  title: _i18n.i18n.translate('xpack.fleet.settings.agentPolicyAdvanced.agentLoggingToFilesTitle', {
    defaultMessage: 'Agent logging to files'
  }),
  description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.settings.agentPolicyAdvanced.agentLoggingToFilesDescription",
    defaultMessage: "Enables logging to rotating files."
  }),
  api_field: {
    name: 'agent_logging_to_files'
  },
  learnMoreLink: 'https://www.elastic.co/guide/en/fleet/current/elastic-agent-standalone-logging-config.html#elastic-agent-standalone-logging-settings',
  schema: _zod.z.boolean().default(true)
}, {
  name: 'agent.logging.files.rotateeverybytes',
  title: _i18n.i18n.translate('xpack.fleet.settings.agentPolicyAdvanced.agentLoggingFileSizeTitle', {
    defaultMessage: 'Agent logging file size limit'
  }),
  description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.settings.agentPolicyAdvanced.agentLoggingFileSizeDescription",
    defaultMessage: "Configure log file size limit in bytes. If limit is reached, log file will be automatically rotated."
  }),
  api_field: {
    name: 'agent_logging_files_rotateeverybytes'
  },
  learnMoreLink: 'https://www.elastic.co/guide/en/fleet/current/elastic-agent-standalone-logging-config.html#elastic-agent-standalone-logging-settings',
  schema: _zod.z.number().int().min(0)
}, {
  name: 'agent.logging.files.keepfiles',
  title: _i18n.i18n.translate('xpack.fleet.settings.agentPolicyAdvanced.agentLoggingFileLimitTitle', {
    defaultMessage: 'Agent logging number of files'
  }),
  description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.settings.agentPolicyAdvanced.agentLoggingFileLimitDescription",
    defaultMessage: "Number of rotated log files to keep. Oldest files will be deleted first."
  }),
  api_field: {
    name: 'agent_logging_files_keepfiles'
  },
  learnMoreLink: 'https://www.elastic.co/guide/en/fleet/current/elastic-agent-standalone-logging-config.html#elastic-agent-standalone-logging-settings',
  schema: _zod.z.number().int().min(0)
}, {
  name: 'agent.logging.files.interval',
  title: _i18n.i18n.translate('xpack.fleet.settings.agentPolicyAdvanced.agentLoggingFileIntervalitle', {
    defaultMessage: 'Agent logging number of files'
  }),
  description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.settings.agentPolicyAdvanced.agentLoggingFileIntervalescription",
    defaultMessage: "Enable log file rotation on time intervals in addition to size-based rotation, i.e. 24h, 7d."
  }),
  api_field: {
    name: 'agent_logging_files_interval'
  },
  learnMoreLink: 'https://www.elastic.co/guide/en/fleet/current/elastic-agent-standalone-logging-config.html#elastic-agent-standalone-logging-settings',
  schema: zodStringWithDurationValidation
}];