"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isAgentVersionLessThanFleetServer = exports.getFleetServerVersionMessage = exports.checkFleetServerVersion = void 0;
var _gt = _interopRequireDefault(require("semver/functions/gt"));
var _major = _interopRequireDefault(require("semver/functions/major"));
var _minor = _interopRequireDefault(require("semver/functions/minor"));
var _errors = require("../errors");
var _ = require(".");
var _get_min_max_version = require("./get_min_max_version");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// Check the installed fleet server version
const checkFleetServerVersion = (versionToUpgradeNumber, fleetServerAgents, force = false) => {
  const message = getFleetServerVersionMessage(versionToUpgradeNumber, fleetServerAgents, force);
  if (force && message) throw new _errors.AgentRequestInvalidError(message);
  if (message) throw new Error(message);
};
exports.checkFleetServerVersion = checkFleetServerVersion;
const getFleetServerVersionMessage = (versionToUpgradeNumber, fleetServerAgents, force = false) => {
  const fleetServerVersions = fleetServerAgents.map(agent => agent.local_metadata.elastic.agent.version);
  const maxFleetServerVersion = (0, _get_min_max_version.getMaxVersion)(fleetServerVersions);
  if (!maxFleetServerVersion || !versionToUpgradeNumber) {
    return;
  }
  try {
    if (!force && (0, _gt.default)(versionToUpgradeNumber, maxFleetServerVersion) && !(0, _.differsOnlyInPatch)(versionToUpgradeNumber, maxFleetServerVersion)) {
      return `Cannot upgrade to version ${versionToUpgradeNumber} because it is higher than the latest fleet server version ${maxFleetServerVersion}.`;
    }
    const fleetServerMajorGt = (0, _major.default)(maxFleetServerVersion) > (0, _major.default)(versionToUpgradeNumber);
    const fleetServerMajorEqMinorGte = (0, _major.default)(maxFleetServerVersion) === (0, _major.default)(versionToUpgradeNumber) && (0, _minor.default)(maxFleetServerVersion) >= (0, _minor.default)(versionToUpgradeNumber);

    // When force is enabled, only the major and minor versions are checked
    if (force && !(fleetServerMajorGt || fleetServerMajorEqMinorGte)) {
      return `Cannot force upgrade to version ${versionToUpgradeNumber} because it does not satisfy the major and minor of the latest fleet server version ${maxFleetServerVersion}.`;
    }
  } catch (e) {
    return e.message;
  }
};
exports.getFleetServerVersionMessage = getFleetServerVersionMessage;
const isAgentVersionLessThanFleetServer = (versionToUpgradeNumber, fleetServerAgents, force = false) => {
  // For serverless it should not have any fleet server agents
  if (fleetServerAgents.length === 0) {
    return true;
  }
  const fleetServerVersions = fleetServerAgents.map(agent => agent.local_metadata.elastic.agent.version);
  const maxFleetServerVersion = (0, _get_min_max_version.getMaxVersion)(fleetServerVersions);
  if (!maxFleetServerVersion || !versionToUpgradeNumber) {
    return false;
  }
  try {
    if (!force && (0, _gt.default)(versionToUpgradeNumber, maxFleetServerVersion) && !(0, _.differsOnlyInPatch)(versionToUpgradeNumber, maxFleetServerVersion)) return false;
    const fleetServerMajorGt = (0, _major.default)(maxFleetServerVersion) > (0, _major.default)(versionToUpgradeNumber);
    const fleetServerMajorEqMinorGte = (0, _major.default)(maxFleetServerVersion) === (0, _major.default)(versionToUpgradeNumber) && (0, _minor.default)(maxFleetServerVersion) >= (0, _minor.default)(versionToUpgradeNumber);

    // When force is enabled, only the major and minor versions are checked
    if (force && !(fleetServerMajorGt || fleetServerMajorEqMinorGte)) {
      return false;
    }
  } catch (e) {
    return false;
  }
  return true;
};
exports.isAgentVersionLessThanFleetServer = isAgentVersionLessThanFleetServer;