"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.unsetAgentPolicyAccordingToLicenseLevel = exports.isAgentPolicyValidForLicense = void 0;
var _generate_new_agent_policy = require("./generate_new_agent_policy");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function isAgentTamperingPolicyValidForLicense(policy, license) {
  if (license && license.hasAtLeast('platinum')) {
    // platinum allows agent tamper protection
    return true;
  }
  const defaults = (0, _generate_new_agent_policy.agentPolicyWithoutPaidFeatures)(policy);

  // only platinum or higher may modify agent tampering
  if (policy.is_protected !== defaults.is_protected) {
    return false;
  }
  return true;
}
const isAgentPolicyValidForLicense = (policy, license) => {
  return isAgentTamperingPolicyValidForLicense(policy, license);
};

/**
 * Resets paid features in a AgentPolicy back to default values
 * when unsupported by the given license level.
 */
exports.isAgentPolicyValidForLicense = isAgentPolicyValidForLicense;
const unsetAgentPolicyAccordingToLicenseLevel = (policy, license) => {
  if (license && license.hasAtLeast('platinum')) {
    return policy;
  }

  // set any license-gated features back to the defaults
  return (0, _generate_new_agent_policy.agentPolicyWithoutPaidFeatures)(policy);
};
exports.unsetAgentPolicyAccordingToLicenseLevel = unsetAgentPolicyAccordingToLicenseLevel;