"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.renderErrorHandler = void 0;
var _i18n = require("@kbn/i18n");
var _services = require("./services");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const renderErrorHandler = (element, error, handlers) => {
  if (error.name === 'AbortError') {
    handlers.done();
    return;
  }
  (0, _services.getNotifications)().toasts.addError(error, {
    title: _i18n.i18n.translate('expressions.defaultErrorRenderer.errorTitle', {
      defaultMessage: 'Error in visualisation'
    }),
    toastMessage: error.message
  });
  handlers.done();
};
exports.renderErrorHandler = renderErrorHandler;