"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createSplitPoint = createSplitPoint;
exports.getXSeriesPoint = exports.getTooltipActions = void 0;
var _utils = require("@kbn/visualizations-plugin/common/utils");
var _i18n = require("@kbn/i18n");
var _esQuery = require("@kbn/es-query");
var _helpers = require("../../../common/helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function nonNullable(v) {
  return v != null;
}
function createSplitPoint(accessor, value, rows, table) {
  if (value === undefined) return;
  const splitPointRowIndex = rows.findIndex(row => {
    if (Array.isArray(value)) {
      return value.includes(row[accessor]);
    }
    return row[accessor] === value;
  });
  if (splitPointRowIndex !== -1) {
    return {
      row: splitPointRowIndex,
      column: table.columns.findIndex(column => column.id === accessor),
      value: table.rows[splitPointRowIndex][accessor],
      table
    };
  }
}
const getXSeriesPoint = (layer, value, fieldFormats, formattedDatatables, xAxisFormatter, formatFactory) => {
  var _formattedDatatables$;
  const {
    table
  } = layer;
  const xColumn = layer.xAccessor && (0, _utils.getColumnByAccessor)(layer.xAccessor, table.columns);
  const xAccessor = layer.xAccessor ? (0, _utils.getAccessorByDimension)(layer.xAccessor, table.columns) : undefined;
  const xFormat = xColumn ? fieldFormats[layer.layerId].xAccessors[xColumn.id] : undefined;
  const currentXFormatter = xAccessor && (_formattedDatatables$ = formattedDatatables[layer.layerId]) !== null && _formattedDatatables$ !== void 0 && _formattedDatatables$.formattedColumns[xAccessor] && xColumn ? formatFactory(xFormat) : xAxisFormatter;
  const rowIndex = table.rows.findIndex(row => {
    if (xAccessor) {
      var _formattedDatatables$2;
      if ((_formattedDatatables$2 = formattedDatatables[layer.layerId]) !== null && _formattedDatatables$2 !== void 0 && _formattedDatatables$2.formattedColumns[xAccessor]) {
        // stringify the value to compare with the chart value
        return currentXFormatter.convert(row[xAccessor]) === value;
      }
      return row[xAccessor] === value;
    }
  });
  return {
    row: rowIndex,
    column: table.columns.findIndex(col => col.id === xAccessor),
    table,
    value: xAccessor ? table.rows[rowIndex][xAccessor] : value
  };
};
exports.getXSeriesPoint = getXSeriesPoint;
function getXSeriesValue(dataLayers, firstSeries) {
  var _firstSeries$datum;
  const layer = dataLayers.find(l => firstSeries.seriesIdentifier.seriesKeys.some(key => l.accessors.some(accessor => (0, _utils.getAccessorByDimension)(accessor, l.table.columns) === key.toString())));
  if (!layer) return;
  const {
    table
  } = layer;
  const xAccessor = layer.xAccessor ? (0, _utils.getAccessorByDimension)(layer.xAccessor, table.columns) : undefined;
  return xAccessor ? (_firstSeries$datum = firstSeries.datum) === null || _firstSeries$datum === void 0 ? void 0 : _firstSeries$datum[xAccessor] : null;
}
const getTooltipActions = (dataLayers, onClickMultiValue, fieldFormats, formattedDatatables, xAxisFormatter, formatFactory, isEnabled) => {
  if (!isEnabled) return;
  const hasSplitAccessors = dataLayers.some(l => {
    var _l$splitAccessors;
    return (_l$splitAccessors = l.splitAccessors) === null || _l$splitAccessors === void 0 ? void 0 : _l$splitAccessors.length;
  });
  const hasXAxis = dataLayers.every(l => l.xAccessor);
  const isTimeViz = (0, _helpers.isTimeChart)(dataLayers);
  if (!hasSplitAccessors && !hasXAxis) return;
  const xSeriesActions = hasXAxis ? [{
    disabled: () => !hasXAxis,
    label: (_, [firstSeries]) => {
      if (isTimeViz) {
        return _i18n.i18n.translate('expressionXY.tooltipActions.filterByTime', {
          defaultMessage: 'Filter by time'
        });
      }
      const value = getXSeriesValue(dataLayers, firstSeries);
      return _i18n.i18n.translate('expressionXY.tooltipActions.filterForXSeries', {
        defaultMessage: 'Filter for {value}',
        values: {
          value: xAxisFormatter.convert(value) || value
        }
      });
    },
    onSelect: (_, [firstSeries]) => {
      const layer = dataLayers.find(l => firstSeries.seriesIdentifier.seriesKeys.some(key => l.accessors.some(accessor => (0, _utils.getAccessorByDimension)(accessor, l.table.columns) === key.toString())));
      if (!layer) return;
      const value = getXSeriesValue(dataLayers, firstSeries);
      const xSeriesPoint = getXSeriesPoint(layer, value, fieldFormats, formattedDatatables, xAxisFormatter, formatFactory);
      const context = {
        data: [{
          table: xSeriesPoint.table,
          cells: [{
            row: xSeriesPoint.row,
            column: xSeriesPoint.column
          }]
        }]
      };
      onClickMultiValue(context);
    }
  }] : [];
  const breakdownTooltipActions = hasSplitAccessors ? [{
    disabled: selected => selected.length < 1,
    label: selected => selected.length === 0 ? _i18n.i18n.translate('expressionXY.tooltipActions.emptyFilterSelection', {
      defaultMessage: 'Select at least one series to filter'
    }) : _i18n.i18n.translate('expressionXY.tooltipActions.filterValues', {
      defaultMessage: 'Filter {seriesNumber} selected series',
      values: {
        seriesNumber: selected.length
      }
    }),
    onSelect: tooltipSelectedValues => {
      const layerIndexes = [];
      tooltipSelectedValues.forEach(v => {
        const index = dataLayers.findIndex(l => v.seriesIdentifier.seriesKeys.some(key => l.accessors.some(accessor => (0, _utils.getAccessorByDimension)(accessor, l.table.columns) === key.toString())));
        if (!layerIndexes.includes(index) && index !== -1) {
          layerIndexes.push(index);
        }
      });
      const filterPoints = [];
      if (!layerIndexes.length) return;
      layerIndexes.forEach(layerIndex => {
        var _layer$splitAccessors;
        const layer = dataLayers[layerIndex];
        const {
          table
        } = layer;
        if (((_layer$splitAccessors = layer.splitAccessors) === null || _layer$splitAccessors === void 0 ? void 0 : _layer$splitAccessors.length) !== 1) return;
        const splitAccessor = (0, _utils.getAccessorByDimension)(layer.splitAccessors[0], table.columns);
        const splitPoints = tooltipSelectedValues.map(v => {
          var _v$datum;
          return createSplitPoint(splitAccessor, (_v$datum = v.datum) === null || _v$datum === void 0 ? void 0 : _v$datum[splitAccessor], formattedDatatables[layer.layerId].table.rows, table);
        }).filter(nonNullable);
        if (splitPoints.length) {
          filterPoints.push({
            cells: splitPoints.map(({
              row,
              column
            }) => ({
              row,
              column
            })),
            relation: _esQuery.BooleanRelation.OR,
            table
          });
        }
      });
      if (filterPoints !== null && filterPoints !== void 0 && filterPoints.length) {
        onClickMultiValue({
          data: filterPoints
        });
      }
    }
  }] : [];
  return [...xSeriesActions, ...breakdownTooltipActions];
};
exports.getTooltipActions = getTooltipActions;