"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getShapeComponent = exports.createShape = void 0;
exports.getShapeContentElement = getShapeContentElement;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _lib = require("../../../common/lib");
var _types = require("./types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const getShapeComponent = svgParams => function Shape({
  shapeAttributes,
  shapeContentAttributes,
  children,
  textAttributes
}) {
  const {
    viewBox: initialViewBox,
    shapeProps: defaultShapeContentAttributes,
    textAttributes: defaultTextAttributes,
    shapeType
  } = svgParams;
  const viewBox = shapeAttributes !== null && shapeAttributes !== void 0 && shapeAttributes.viewBox ? (0, _lib.viewBoxToString)(shapeAttributes === null || shapeAttributes === void 0 ? void 0 : shapeAttributes.viewBox) : (0, _lib.viewBoxToString)(initialViewBox);
  const SvgContentElement = getShapeContentElement(shapeType);
  const TextElement = textAttributes ? /*#__PURE__*/_react.default.forwardRef((props, ref) => /*#__PURE__*/_react.default.createElement("text", (0, _extends2.default)({}, props, {
    ref: ref
  }))) : null;
  return /*#__PURE__*/_react.default.createElement("svg", (0, _extends2.default)({
    xmlns: "http://www.w3.org/2000/svg"
  }, shapeAttributes || {}, {
    viewBox
  }), /*#__PURE__*/_react.default.createElement(SvgContentElement, (0, _extends2.default)({}, defaultShapeContentAttributes, shapeContentAttributes || {})), children, TextElement && /*#__PURE__*/_react.default.createElement(TextElement, (0, _extends2.default)({}, defaultTextAttributes || {}, textAttributes || {}), textAttributes === null || textAttributes === void 0 ? void 0 : textAttributes.textContent));
};
exports.getShapeComponent = getShapeComponent;
function getShapeContentElement(type) {
  switch (type) {
    case _types.SvgElementTypes.circle:
      return /*#__PURE__*/_react.default.forwardRef((props, ref) => /*#__PURE__*/_react.default.createElement("circle", (0, _extends2.default)({}, props, {
        ref: ref
      })));
    case _types.SvgElementTypes.rect:
      return /*#__PURE__*/_react.default.forwardRef((props, ref) => /*#__PURE__*/_react.default.createElement("rect", (0, _extends2.default)({}, props, {
        ref: ref
      })));
    case _types.SvgElementTypes.path:
      return /*#__PURE__*/_react.default.forwardRef((props, ref) => /*#__PURE__*/_react.default.createElement("path", (0, _extends2.default)({}, props, {
        ref: ref
      })));
    default:
      return /*#__PURE__*/_react.default.forwardRef((props, ref) => /*#__PURE__*/_react.default.createElement("polygon", (0, _extends2.default)({}, props, {
        ref: ref
      })));
  }
}
const createShape = props => {
  return {
    Component: getShapeComponent(props),
    data: props
  };
};
exports.createShape = createShape;