"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.filterOutConfig = void 0;
var _types = require("../../common/types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const filterOutConfig = (visType, visConfig) => {
  if ([_types.ChartTypes.PIE, _types.ChartTypes.DONUT].includes(visType)) {
    return visConfig;
  }
  const {
    last_level: lastLevel,
    truncate,
    ...restLabelsConfig
  } = visConfig.labels;
  return {
    ...visConfig,
    labels: restLabelsConfig
  };
};
exports.filterOutConfig = filterOutConfig;