"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createSplitPoint = createSplitPoint;
exports.getSplitDimensionAccessor = void 0;
var _utils = require("@kbn/visualizations-plugin/common/utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const getSplitDimensionAccessor = (columns, splitDimension, formatFactory) => {
  var _splitChartColumn$met;
  const splitChartColumn = (0, _utils.getColumnByAccessor)(splitDimension, columns);
  const accessor = splitChartColumn.id;
  const formatter = formatFactory((_splitChartColumn$met = splitChartColumn.meta) === null || _splitChartColumn$met === void 0 ? void 0 : _splitChartColumn$met.params);
  const fn = d => {
    const v = d[accessor];
    if (v === undefined) {
      return;
    }
    const f = formatter.convert(v);
    return f;
  };
  return fn;
};
exports.getSplitDimensionAccessor = getSplitDimensionAccessor;
function createSplitPoint(splitDimension, value, formatFactory, table) {
  var _splitChartColumn$met2;
  const splitChartColumn = (0, _utils.getColumnByAccessor)(splitDimension, table.columns);
  const accessor = splitChartColumn.id;
  const formatter = formatFactory((_splitChartColumn$met2 = splitChartColumn.meta) === null || _splitChartColumn$met2 === void 0 ? void 0 : _splitChartColumn$met2.params);
  const splitPointRowIndex = table.rows.findIndex(row => {
    return formatter.convert(row[accessor]) === value;
  });
  if (splitPointRowIndex !== -1) {
    return {
      row: splitPointRowIndex,
      column: table.columns.findIndex(column => column.id === accessor),
      value: table.rows[splitPointRowIndex][accessor],
      table
    };
  }
}