"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.REFRESH_LABEL = void 0;
exports.RefreshButton = RefreshButton;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _last_updated = require("./last_updated");
var _use_series_storage = require("../hooks/use_series_storage");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function RefreshButton() {
  const {
    setLastRefresh,
    chartTimeRangeContext
  } = (0, _use_series_storage.useSeriesStorage)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "m"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    style: {
      textAlign: 'right',
      minWidth: 280
    }
  }, /*#__PURE__*/_react.default.createElement(_last_updated.LastUpdated, {
    chartTimeRange: chartTimeRangeContext
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    style: {
      textAlign: 'right'
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "o11yRefreshButtonButton",
    iconType: "refresh",
    onClick: () => setLastRefresh(Date.now())
  }, REFRESH_LABEL)));
}
const REFRESH_LABEL = exports.REFRESH_LABEL = _i18n.i18n.translate('xpack.exploratoryView.refresh', {
  defaultMessage: 'Refresh'
});