"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getAlertsSingleMetricConfig = getAlertsSingleMetricConfig;
var _constants = require("../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getAlertsSingleMetricConfig({
  spaceId
}) {
  return {
    seriesTypes: [],
    defaultSeriesType: 'line',
    reportType: _constants.ReportTypes.SINGLE_METRIC,
    xAxisColumn: {},
    yAxisColumns: [{
      operationType: 'median'
    }],
    hasOperationType: false,
    filterFields: ['kibana.alert.rule.name', 'kibana.alert.status'],
    breakdownFields: ['kibana.alert.rule.category', 'kibana.alert.status'],
    baseFilters: [],
    definitionFields: ['kibana.alert.rule.category'],
    metricOptions: [{
      label: 'Active',
      field: _constants.RECORDS_FIELD,
      id: 'Alerts',
      columnType: 'unique_count',
      metricStateOptions: {
        titlePosition: 'bottom'
      },
      emptyAsNull: false
    }],
    labels: {
      ..._constants.FieldLabels
    },
    query: {
      language: 'kuery',
      query: `kibana.space_ids: "${spaceId}"`
    }
  };
}