"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EventAnnotationGroupStorage = void 0;
var _contentManagementUtils = require("@kbn/content-management-utils");
var _eventAnnotationCommon = require("@kbn/event-annotation-common");
var _cm_services = require("./schema/cm_services");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

class EventAnnotationGroupStorage extends _contentManagementUtils.SOContentStorage {
  constructor({
    logger,
    throwOnResultValidationError
  }) {
    super({
      savedObjectType: _eventAnnotationCommon.EVENT_ANNOTATION_GROUP_TYPE,
      cmServicesDefinition: _cm_services.cmServicesDefinition,
      enableMSearch: true,
      allowedSavedObjectAttributes: ['title', 'description', 'annotations', 'ignoreGlobalFilters', 'dataViewSpec'],
      logger,
      throwOnResultValidationError
    });
  }
}
exports.EventAnnotationGroupStorage = EventAnnotationGroupStorage;