"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.queryContainsFunction = exports.queryCannotBeSampled = void 0;
var _esqlAst = require("@kbn/esql-ast");
var _esQuery = require("@kbn/es-query");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/**
 * Check if the query contains any of the function names being passed in
 * @param query
 * @param functions list of function names to check for
 * @returns
 */
const queryContainsFunction = (query, functions) => {
  if (query && (0, _esQuery.isOfAggregateQueryType)(query)) {
    const {
      root
    } = (0, _esqlAst.parse)(query.esql);
    return functions.some(f => _esqlAst.Walker.hasFunction(root, f) ||
    // Walker API expects valid queries so we need to do additional check for partial matches
    root.commands.some(c => c.text.toLowerCase().includes(`${f}(`)));
  }
  return false;
};
exports.queryContainsFunction = queryContainsFunction;
const UNSAMPLABLE_FUNCTIONS = ['match', 'qstr'];
/**
 * Check if the query contains any function that cannot be used after LIMIT clause
 * @param query
 * @returns
 */
const queryCannotBeSampled = query => {
  return queryContainsFunction(query, UNSAMPLABLE_FUNCTIONS);
};
exports.queryCannotBeSampled = queryCannotBeSampled;