"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.cmd = void 0;
var _query = require("../query");
var _helpers = require("./helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const generator = (src, {
  withFormatting = true,
  ...rest
} = {}) => {
  src = src.trimStart();
  const isSourceCommand = /^FROM/i.test(src);
  const querySrc = isSourceCommand ? src : 'FROM a | ' + src;
  const query = _query.EsqlQuery.fromSrc(querySrc, {
    withFormatting,
    ...rest
  });
  const command = query.ast.commands[isSourceCommand ? 0 : 1];
  if (command.type !== 'command') {
    throw new Error('Expected a command node');
  }
  (0, _helpers.makeSynthNode)(command);
  return command;
};
const cmd = exports.cmd = (0, _helpers.createSynthMethod)(generator);