"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ESQLAstBuilderListener = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _esql_parser = _interopRequireWildcard(require("../antlr/esql_parser"));
var _factories = require("./factories");
var _helpers = require("./helpers");
var _walkers = require("./walkers");
var _join = require("./factories/join");
var _dissect = require("./factories/dissect");
var _grok = require("./factories/grok");
var _stats = require("./factories/stats");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

class ESQLAstBuilderListener {
  constructor(src) {
    (0, _defineProperty2.default)(this, "ast", []);
    this.src = src;
  }
  getAst() {
    return {
      ast: this.ast
    };
  }

  /**
   * Exit a parse tree produced by the `showInfo`
   * labeled alternative in `esql_parser.showCommand`.
   * @param ctx the parse tree
   */
  exitShowInfo(ctx) {
    const commandAst = (0, _factories.createCommand)('show', ctx);
    this.ast.push(commandAst);
    commandAst.text = ctx.getText();
    if ((0, _factories.textExistsAndIsValid)(ctx.INFO().getText())) {
      // TODO: these probably should not be functions, instead use "column", like: INFO <identifier>?
      commandAst === null || commandAst === void 0 ? void 0 : commandAst.args.push((0, _factories.createFunction)('info', ctx, (0, _helpers.getPosition)(ctx.INFO().symbol)));
    }
  }

  /**
   * Enter a parse tree produced by `esql_parser.singleStatement`.
   * @param ctx the parse tree
   */
  enterSingleStatement(ctx) {
    this.ast = [];
  }

  /**
   * Exit a parse tree produced by `esql_parser.whereCommand`.
   * @param ctx the parse tree
   */
  exitWhereCommand(ctx) {
    const command = (0, _factories.createCommand)('where', ctx);
    this.ast.push(command);
    command.args.push(...(0, _walkers.collectBooleanExpression)(ctx.booleanExpression()));
  }

  /**
   * Exit a parse tree produced by `esql_parser.rowCommand`.
   * @param ctx the parse tree
   */
  exitRowCommand(ctx) {
    const command = (0, _factories.createCommand)('row', ctx);
    this.ast.push(command);
    command.args.push(...(0, _walkers.collectAllFields)(ctx.fields()));
  }

  /**
   * Exit a parse tree produced by `esql_parser.fromCommand`.
   * @param ctx the parse tree
   */
  exitFromCommand(ctx) {
    const commandAst = (0, _factories.createCommand)('from', ctx);
    this.ast.push(commandAst);
    commandAst.args.push(...(0, _walkers.collectAllSourceIdentifiers)(ctx));
    const metadataContext = ctx.metadata();
    if (metadataContext && metadataContext.METADATA()) {
      const option = (0, _factories.createOption)(metadataContext.METADATA().getText().toLowerCase(), metadataContext);
      commandAst.args.push(option);
      option.args.push(...(0, _walkers.collectAllColumnIdentifiers)(metadataContext));
    }
  }

  /**
   * Exit a parse tree produced by `esql_parser.metricsCommand`.
   * @param ctx the parse tree
   */
  exitMetricsCommand(ctx) {
    const node = {
      ...(0, _factories.createAstBaseItem)('metrics', ctx),
      type: 'command',
      args: [],
      sources: ctx.getTypedRuleContexts(_esql_parser.IndexPatternContext).map(sourceCtx => (0, _factories.createSource)(sourceCtx))
    };
    this.ast.push(node);
    const aggregates = (0, _walkers.collectAllAggFields)(ctx.aggFields());
    const grouping = (0, _walkers.collectAllFields)(ctx.fields());
    if (aggregates && aggregates.length) {
      node.aggregates = aggregates;
    }
    if (grouping && grouping.length) {
      node.grouping = grouping;
    }
    node.args.push(...node.sources, ...aggregates, ...grouping);
  }

  /**
   * Exit a parse tree produced by `esql_parser.evalCommand`.
   * @param ctx the parse tree
   */
  exitEvalCommand(ctx) {
    const commandAst = (0, _factories.createCommand)('eval', ctx);
    this.ast.push(commandAst);
    commandAst.args.push(...(0, _walkers.collectAllFields)(ctx.fields()));
  }

  /**
   * Exit a parse tree produced by `esql_parser.statsCommand`.
   * @param ctx the parse tree
   */
  exitStatsCommand(ctx) {
    const command = (0, _stats.createStatsCommand)(ctx, this.src);
    this.ast.push(command);
  }

  /**
   * Exit a parse tree produced by `esql_parser.inlinestatsCommand`.
   * @param ctx the parse tree
   */
  exitInlinestatsCommand(ctx) {
    const command = (0, _factories.createCommand)('inlinestats', ctx);
    this.ast.push(command);

    // STATS expression is optional
    if (ctx._stats) {
      command.args.push(...(0, _walkers.collectAllAggFields)(ctx.aggFields()));
    }
    if (ctx._grouping) {
      command.args.push(...(0, _walkers.visitByOption)(ctx, ctx.fields()));
    }
  }

  /**
   * Exit a parse tree produced by `esql_parser.limitCommand`.
   * @param ctx the parse tree
   */
  exitLimitCommand(ctx) {
    const command = (0, _factories.createCommand)('limit', ctx);
    this.ast.push(command);
    if (ctx.getToken(_esql_parser.default.INTEGER_LITERAL, 0)) {
      const literal = (0, _factories.createLiteral)('integer', ctx.INTEGER_LITERAL());
      if (literal) {
        command.args.push(literal);
      }
    }
  }

  /**
   * Exit a parse tree produced by `esql_parser.sortCommand`.
   * @param ctx the parse tree
   */
  exitSortCommand(ctx) {
    const command = (0, _factories.createCommand)('sort', ctx);
    this.ast.push(command);
    command.args.push(...(0, _walkers.visitOrderExpressions)(ctx.orderExpression_list()));
  }

  /**
   * Exit a parse tree produced by `esql_parser.keepCommand`.
   * @param ctx the parse tree
   */
  exitKeepCommand(ctx) {
    const command = (0, _factories.createCommand)('keep', ctx);
    this.ast.push(command);
    command.args.push(...(0, _walkers.collectAllColumnIdentifiers)(ctx));
  }

  /**
   * Exit a parse tree produced by `esql_parser.dropCommand`.
   * @param ctx the parse tree
   */
  exitDropCommand(ctx) {
    const command = (0, _factories.createCommand)('drop', ctx);
    this.ast.push(command);
    command.args.push(...(0, _walkers.collectAllColumnIdentifiers)(ctx));
  }

  /**
   * Exit a parse tree produced by `esql_parser.renameCommand`.
   * @param ctx the parse tree
   */
  exitRenameCommand(ctx) {
    const command = (0, _factories.createCommand)('rename', ctx);
    this.ast.push(command);
    command.args.push(...(0, _walkers.visitRenameClauses)(ctx.renameClause_list()));
  }

  /**
   * Exit a parse tree produced by `esql_parser.dissectCommand`.
   * @param ctx the parse tree
   */
  exitDissectCommand(ctx) {
    const command = (0, _dissect.createDissectCommand)(ctx);
    this.ast.push(command);
  }

  /**
   * Exit a parse tree produced by `esql_parser.grokCommand`.
   * @param ctx the parse tree
   */
  exitGrokCommand(ctx) {
    const command = (0, _grok.createGrokCommand)(ctx);
    this.ast.push(command);
  }

  /**
   * Exit a parse tree produced by `esql_parser.mvExpandCommand`.
   * @param ctx the parse tree
   */
  exitMvExpandCommand(ctx) {
    const command = (0, _factories.createCommand)('mv_expand', ctx);
    this.ast.push(command);
    command.args.push(...(0, _walkers.collectAllColumnIdentifiers)(ctx));
  }

  /**
   * Enter a parse tree produced by `esql_parser.showCommand`.
   * @param ctx the parse tree
   */
  enterShowCommand(ctx) {
    const command = (0, _factories.createCommand)('show', ctx);
    this.ast.push(command);
  }

  /**
   * Exit a parse tree produced by `esql_parser.enrichCommand`.
   * @param ctx the parse tree
   */
  exitEnrichCommand(ctx) {
    const command = (0, _factories.createCommand)('enrich', ctx);
    this.ast.push(command);
    command.args.push(...(0, _walkers.getPolicyName)(ctx), ...(0, _walkers.getMatchField)(ctx), ...(0, _walkers.getEnrichClauses)(ctx));
  }

  /**
   * Exit a parse tree produced by `esql_parser.joinCommand`.
   *
   * Parse the JOIN command:
   *
   * ```
   * <type> JOIN identifier [ AS identifier ] ON expression [, expression [, ... ]]
   * ```
   *
   * @param ctx the parse tree
   */
  exitJoinCommand(ctx) {
    const command = (0, _join.createJoinCommand)(ctx);
    this.ast.push(command);
  }
  enterEveryRule(ctx) {
    // method not implemented, added to satisfy interface expectation
  }
  visitErrorNode(node) {
    // method not implemented, added to satisfy interface expectation
  }
  visitTerminal(node) {
    // method not implemented, added to satisfy interface expectation
  }
  exitEveryRule(ctx) {
    // method not implemented, added to satisfy interface expectation
  }
}
exports.ESQLAstBuilderListener = ESQLAstBuilderListener;