"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TICKS_REGEX = exports.SINGLE_TICK_REGEX = exports.SINGLE_BACKTICK = exports.HIDDEN_CHANNEL = exports.GRAMMAR_ROOT_RULE = exports.EDITOR_MARKER = exports.DOUBLE_TICKS_REGEX = exports.DOUBLE_BACKTICK = exports.DEFAULT_CHANNEL = void 0;
var _antlr = require("antlr4");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/**
 * The root ANTLR rule to start parsing from.
 */
const GRAMMAR_ROOT_RULE = exports.GRAMMAR_ROOT_RULE = 'singleStatement';
const EDITOR_MARKER = exports.EDITOR_MARKER = 'marker_esql_editor';
const TICKS_REGEX = exports.TICKS_REGEX = /^`{1}|`{1}$/g;
const DOUBLE_TICKS_REGEX = exports.DOUBLE_TICKS_REGEX = /``/g;
const SINGLE_TICK_REGEX = exports.SINGLE_TICK_REGEX = /`/g;
const SINGLE_BACKTICK = exports.SINGLE_BACKTICK = '`';
const DOUBLE_BACKTICK = exports.DOUBLE_BACKTICK = '``';
const DEFAULT_CHANNEL = exports.DEFAULT_CHANNEL = +_antlr.Token.DEFAULT_CHANNEL;
const HIDDEN_CHANNEL = exports.HIDDEN_CHANNEL = +_antlr.Token.HIDDEN_CHANNEL;