"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.entitiesEventComponentTemplateConfig = void 0;
var _constants_entities = require("../../../common/constants_entities");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const entitiesEventComponentTemplateConfig = exports.entitiesEventComponentTemplateConfig = {
  name: _constants_entities.ENTITY_EVENT_COMPONENT_TEMPLATE_V1,
  _meta: {
    description: "Component template for the event fields used in the Elastic Entity Model's entity discovery framework",
    documentation: 'https://www.elastic.co/guide/en/ecs/current/ecs-event.html',
    ecs_version: '8.0.0',
    managed: true
  },
  template: {
    mappings: {
      properties: {
        event: {
          properties: {
            ingested: {
              type: 'date'
            }
          }
        }
      }
    }
  }
};