"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.typeDefinitionRoutes = void 0;
var _zod = require("@kbn/zod");
var _constants = require("../../lib/v2/constants");
var _types = require("../../lib/v2/types");
var _create_entity_manager_server_route = require("../create_entity_manager_server_route");
var _entity_definition_conflict = require("../../lib/v2/errors/entity_definition_conflict");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createTypeDefinitionRoute = (0, _create_entity_manager_server_route.createEntityManagerServerRoute)({
  endpoint: 'POST /internal/entities/v2/definitions/types',
  security: {
    authz: {
      requiredPrivileges: [_constants.CREATE_ENTITY_TYPE_DEFINITION_PRIVILEGE]
    }
  },
  params: _zod.z.object({
    body: _zod.z.object({
      type: _types.entityTypeDefinitionRt
    })
  }),
  handler: async ({
    request,
    response,
    params,
    getScopedClient
  }) => {
    try {
      const client = await getScopedClient({
        request
      });
      const type = await client.v2.storeTypeDefinition(params.body.type);
      return response.created({
        body: {
          type
        },
        headers: {
          location: `GET /internal/entities/v2/definitions/types/${type.id}`
        }
      });
    } catch (error) {
      if (error instanceof _entity_definition_conflict.EntityDefinitionConflict) {
        return response.conflict({
          body: {
            message: error.message
          }
        });
      }
      throw error;
    }
  }
});
const readTypeDefinitionsRoute = (0, _create_entity_manager_server_route.createEntityManagerServerRoute)({
  endpoint: 'GET /internal/entities/v2/definitions/types',
  security: {
    authz: {
      requiredPrivileges: [_constants.READ_ENTITY_TYPE_DEFINITION_PRIVILEGE]
    }
  },
  handler: async ({
    request,
    response,
    getScopedClient
  }) => {
    const client = await getScopedClient({
      request
    });
    const types = await client.v2.readTypeDefinitions();
    return response.ok({
      body: {
        types
      }
    });
  }
});
const typeDefinitionRoutes = exports.typeDefinitionRoutes = {
  ...createTypeDefinitionRoute,
  ...readTypeDefinitionsRoute
};