"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.builtInHostsFromEcsEntityDefinition = void 0;
var _constants = require("./constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const builtInHostsFromEcsEntityDefinition = exports.builtInHostsFromEcsEntityDefinition = {
  type: {
    id: `${_constants.BUILT_IN_ID_PREFIX}hosts_from_ecs_data`,
    display_name: 'Hosts'
  },
  sources: [{
    id: `${_constants.BUILT_IN_ID_PREFIX}hosts_from_ecs_data_ecs`,
    type_id: `${_constants.BUILT_IN_ID_PREFIX}hosts_from_ecs_data`,
    index_patterns: ['filebeat-*', 'logs-*', 'metrics-*', 'metricbeat-*'],
    identity_fields: ['host.name'],
    display_name: 'host.name',
    timestamp_field: '@timestamp',
    metadata_fields: [],
    filters: []
  }]
};