"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.readEntityDefinition = readEntityDefinition;
var _entitiesSchema = require("@kbn/entities-schema");
var _saved_objects = require("../../saved_objects");
var _entity_not_found = require("./errors/entity_not_found");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function readEntityDefinition(soClient, id, logger) {
  const response = await soClient.find({
    type: _saved_objects.SO_ENTITY_DEFINITION_TYPE,
    page: 1,
    perPage: 1,
    filter: `${_saved_objects.SO_ENTITY_DEFINITION_TYPE}.attributes.id:(${id})`
  });
  if (response.total === 0) {
    const message = `Unable to find entity definition with [${id}]`;
    logger.error(message);
    throw new _entity_not_found.EntityDefinitionNotFound(message);
  }
  try {
    return _entitiesSchema.entityDefinitionSchema.parse(response.saved_objects[0].attributes);
  } catch (e) {
    logger.error(`Unable to parse entity definition with [${id}]: ${e}`);
    throw e;
  }
}