"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.startMlModelDownload = void 0;
var _ml = require("../../../common/types/ml");
var _get_ml_model_deployment_status = require("./get_ml_model_deployment_status");
var _ml_model_deployment_common = require("./ml_model_deployment_common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const startMlModelDownload = async (modelName, trainedModelsProvider) => {
  if (!trainedModelsProvider) {
    throw new Error('Machine Learning is not enabled');
  }
  try {
    // try and get the deployment status of the model first
    // and see if it's already deployed or deploying...
    const deploymentStatus = await (0, _get_ml_model_deployment_status.getMlModelDeploymentStatus)(modelName, trainedModelsProvider);
    const deploymentState = (deploymentStatus === null || deploymentStatus === void 0 ? void 0 : deploymentStatus.deploymentState) || _ml.MlModelDeploymentState.NotDeployed;

    // if we're downloading or already started / starting / done
    // return the status
    if (deploymentState !== _ml.MlModelDeploymentState.NotDeployed) {
      return deploymentStatus;
    }
  } catch (error) {
    // don't rethrow the not found here -
    // if it's not found there's a good chance it's not started
    // downloading yet
    if (!(0, _ml_model_deployment_common.isNotFoundExceptionError)(error)) {
      throw error;
    }
  }

  // we're not downloaded yet - let's initiate that...
  const putRequest = {
    input: {
      field_names: ['text_field']
    },
    model_id: modelName
  };

  // this will also sync our saved objects for us
  await trainedModelsProvider.putTrainedModel(putRequest);

  // and return our status
  return await (0, _get_ml_model_deployment_status.getMlModelDeploymentStatus)(modelName, trainedModelsProvider);
};
exports.startMlModelDownload = startMlModelDownload;