"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.deleteAccessControlIndex = void 0;
var _constants = require("../../../common/constants");
var _identify_exceptions = require("../../utils/identify_exceptions");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const deleteAccessControlIndex = async (client, indexName) => {
  const aclIndexName = `${_constants.CONNECTORS_ACCESS_CONTROL_INDEX_PREFIX}${indexName}`;
  try {
    return await client.asCurrentUser.indices.delete({
      index: aclIndexName
    });
  } catch (e) {
    // Gracefully exit if index not found. This is a valid case.
    if (!(0, _identify_exceptions.isIndexNotFoundException)(e)) throw e;
  }
};
exports.deleteAccessControlIndex = deleteAccessControlIndex;