"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createApiKey = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createApiKey = async (client, name, keyName) => {
  return await client.asCurrentUser.security.createApiKey({
    name: keyName,
    role_descriptors: {
      [`${name}-key-role`]: {
        cluster: ['post_behavioral_analytics_event']
      }
    }
  });
};
exports.createApiKey = createApiKey;