"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerTelemetryUsageCollector = exports.fetchTelemetryMetrics = void 0;
var _searchConnectors = require("@kbn/search-connectors");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const defaultTelemetryMetrics = {
  connectors: []
};

/**
 * Register the telemetry collector
 */

const registerTelemetryUsageCollector = (usageCollection, log) => {
  const telemetryUsageCollector = usageCollection.makeUsageCollector({
    type: 'connectors',
    isReady: () => true,
    schema: {
      connectors: {
        type: 'array',
        items: {
          id: {
            type: 'keyword'
          },
          serviceType: {
            type: 'keyword'
          },
          isNative: {
            type: 'boolean'
          },
          isDeleted: {
            type: 'boolean'
          },
          status: {
            type: 'keyword'
          },
          indexName: {
            type: 'keyword'
          },
          dlsEnabled: {
            type: 'boolean'
          },
          sslEnabled: {
            type: 'boolean'
          },
          fetchSelectively: {
            type: 'boolean'
          },
          textExtractionServiceEnabled: {
            type: 'boolean'
          },
          documents: {
            total: {
              type: 'long'
            },
            volume: {
              type: 'long'
            },
            inLastSync: {
              type: 'long'
            }
          },
          dataSourceSpecific: {
            confluence: {
              dataSourceType: {
                type: 'keyword'
              }
            },
            github: {
              isCloud: {
                type: 'boolean'
              }
            },
            jira: {
              dataSourceType: {
                type: 'keyword'
              }
            },
            mongodb: {
              directConnect: {
                type: 'boolean'
              }
            },
            mssql: {
              validateHost: {
                type: 'boolean'
              },
              tables: {
                type: 'long'
              }
            },
            mysql: {
              tables: {
                type: 'long'
              }
            },
            oracle: {
              tables: {
                type: 'long'
              }
            },
            postgresql: {
              tables: {
                type: 'long'
              }
            },
            slack: {
              autoJoinChannelsEnabled: {
                type: 'boolean'
              },
              syncUsersEnabled: {
                type: 'boolean'
              },
              fetchLastNDays: {
                type: 'long'
              }
            },
            zoom: {
              recordingAge: {
                type: 'long'
              }
            }
          },
          scheduling: {
            accessControl: {
              enabled: {
                type: 'boolean'
              },
              interval: {
                type: 'text'
              }
            },
            full: {
              enabled: {
                type: 'boolean'
              },
              interval: {
                type: 'text'
              }
            },
            incremental: {
              enabled: {
                type: 'boolean'
              },
              interval: {
                type: 'text'
              }
            }
          },
          syncRules: {
            active: {
              withBasicRules: {
                type: 'boolean'
              },
              withAdvancedRules: {
                type: 'boolean'
              }
            },
            draft: {
              withBasicRules: {
                type: 'boolean'
              },
              withAdvancedRules: {
                type: 'boolean'
              }
            }
          },
          ingestPipeline: {
            name: {
              type: 'keyword'
            },
            extractBinaryContent: {
              type: 'boolean'
            },
            reduceWhitespace: {
              type: 'boolean'
            },
            runMLInference: {
              type: 'boolean'
            }
          },
          syncJobs: {
            overall: {
              total: {
                type: 'long'
              },
              last30Days: {
                overall: {
                  total: {
                    type: 'long'
                  },
                  manual: {
                    type: 'long'
                  },
                  scheduled: {
                    type: 'long'
                  },
                  completed: {
                    type: 'long'
                  },
                  errored: {
                    type: 'long'
                  },
                  canceled: {
                    type: 'long'
                  },
                  suspended: {
                    type: 'long'
                  },
                  idle: {
                    type: 'long'
                  },
                  running: {
                    type: 'long'
                  },
                  totalDurationSeconds: {
                    type: 'long'
                  },
                  topErrors: {
                    type: 'array',
                    items: {
                      type: 'keyword'
                    }
                  }
                },
                accessControl: {
                  total: {
                    type: 'long'
                  },
                  manual: {
                    type: 'long'
                  },
                  scheduled: {
                    type: 'long'
                  },
                  completed: {
                    type: 'long'
                  },
                  errored: {
                    type: 'long'
                  },
                  canceled: {
                    type: 'long'
                  },
                  suspended: {
                    type: 'long'
                  },
                  idle: {
                    type: 'long'
                  },
                  running: {
                    type: 'long'
                  },
                  totalDurationSeconds: {
                    type: 'long'
                  },
                  topErrors: {
                    type: 'array',
                    items: {
                      type: 'keyword'
                    }
                  }
                },
                full: {
                  total: {
                    type: 'long'
                  },
                  manual: {
                    type: 'long'
                  },
                  scheduled: {
                    type: 'long'
                  },
                  completed: {
                    type: 'long'
                  },
                  errored: {
                    type: 'long'
                  },
                  canceled: {
                    type: 'long'
                  },
                  suspended: {
                    type: 'long'
                  },
                  idle: {
                    type: 'long'
                  },
                  running: {
                    type: 'long'
                  },
                  totalDurationSeconds: {
                    type: 'long'
                  },
                  topErrors: {
                    type: 'array',
                    items: {
                      type: 'keyword'
                    }
                  }
                },
                incremental: {
                  total: {
                    type: 'long'
                  },
                  manual: {
                    type: 'long'
                  },
                  scheduled: {
                    type: 'long'
                  },
                  completed: {
                    type: 'long'
                  },
                  errored: {
                    type: 'long'
                  },
                  canceled: {
                    type: 'long'
                  },
                  suspended: {
                    type: 'long'
                  },
                  idle: {
                    type: 'long'
                  },
                  running: {
                    type: 'long'
                  },
                  totalDurationSeconds: {
                    type: 'long'
                  },
                  topErrors: {
                    type: 'array',
                    items: {
                      type: 'keyword'
                    }
                  }
                }
              },
              last7Days: {
                overall: {
                  total: {
                    type: 'long'
                  },
                  manual: {
                    type: 'long'
                  },
                  scheduled: {
                    type: 'long'
                  },
                  completed: {
                    type: 'long'
                  },
                  errored: {
                    type: 'long'
                  },
                  canceled: {
                    type: 'long'
                  },
                  suspended: {
                    type: 'long'
                  },
                  idle: {
                    type: 'long'
                  },
                  running: {
                    type: 'long'
                  },
                  totalDurationSeconds: {
                    type: 'long'
                  },
                  topErrors: {
                    type: 'array',
                    items: {
                      type: 'keyword'
                    }
                  }
                },
                accessControl: {
                  total: {
                    type: 'long'
                  },
                  manual: {
                    type: 'long'
                  },
                  scheduled: {
                    type: 'long'
                  },
                  completed: {
                    type: 'long'
                  },
                  errored: {
                    type: 'long'
                  },
                  canceled: {
                    type: 'long'
                  },
                  suspended: {
                    type: 'long'
                  },
                  idle: {
                    type: 'long'
                  },
                  running: {
                    type: 'long'
                  },
                  totalDurationSeconds: {
                    type: 'long'
                  },
                  topErrors: {
                    type: 'array',
                    items: {
                      type: 'keyword'
                    }
                  }
                },
                full: {
                  total: {
                    type: 'long'
                  },
                  manual: {
                    type: 'long'
                  },
                  scheduled: {
                    type: 'long'
                  },
                  completed: {
                    type: 'long'
                  },
                  errored: {
                    type: 'long'
                  },
                  canceled: {
                    type: 'long'
                  },
                  suspended: {
                    type: 'long'
                  },
                  idle: {
                    type: 'long'
                  },
                  running: {
                    type: 'long'
                  },
                  totalDurationSeconds: {
                    type: 'long'
                  },
                  topErrors: {
                    type: 'array',
                    items: {
                      type: 'keyword'
                    }
                  }
                },
                incremental: {
                  total: {
                    type: 'long'
                  },
                  manual: {
                    type: 'long'
                  },
                  scheduled: {
                    type: 'long'
                  },
                  completed: {
                    type: 'long'
                  },
                  errored: {
                    type: 'long'
                  },
                  canceled: {
                    type: 'long'
                  },
                  suspended: {
                    type: 'long'
                  },
                  idle: {
                    type: 'long'
                  },
                  running: {
                    type: 'long'
                  },
                  totalDurationSeconds: {
                    type: 'long'
                  },
                  topErrors: {
                    type: 'array',
                    items: {
                      type: 'keyword'
                    }
                  }
                }
              }
            },
            withTextExtractionServiceEnabled: {
              total: {
                type: 'long'
              },
              last30Days: {
                overall: {
                  total: {
                    type: 'long'
                  },
                  manual: {
                    type: 'long'
                  },
                  scheduled: {
                    type: 'long'
                  },
                  completed: {
                    type: 'long'
                  },
                  errored: {
                    type: 'long'
                  },
                  canceled: {
                    type: 'long'
                  },
                  suspended: {
                    type: 'long'
                  },
                  idle: {
                    type: 'long'
                  },
                  running: {
                    type: 'long'
                  },
                  totalDurationSeconds: {
                    type: 'long'
                  },
                  topErrors: {
                    type: 'array',
                    items: {
                      type: 'keyword'
                    }
                  }
                },
                accessControl: {
                  total: {
                    type: 'long'
                  },
                  manual: {
                    type: 'long'
                  },
                  scheduled: {
                    type: 'long'
                  },
                  completed: {
                    type: 'long'
                  },
                  errored: {
                    type: 'long'
                  },
                  canceled: {
                    type: 'long'
                  },
                  suspended: {
                    type: 'long'
                  },
                  idle: {
                    type: 'long'
                  },
                  running: {
                    type: 'long'
                  },
                  totalDurationSeconds: {
                    type: 'long'
                  },
                  topErrors: {
                    type: 'array',
                    items: {
                      type: 'keyword'
                    }
                  }
                },
                full: {
                  total: {
                    type: 'long'
                  },
                  manual: {
                    type: 'long'
                  },
                  scheduled: {
                    type: 'long'
                  },
                  completed: {
                    type: 'long'
                  },
                  errored: {
                    type: 'long'
                  },
                  canceled: {
                    type: 'long'
                  },
                  suspended: {
                    type: 'long'
                  },
                  idle: {
                    type: 'long'
                  },
                  running: {
                    type: 'long'
                  },
                  totalDurationSeconds: {
                    type: 'long'
                  },
                  topErrors: {
                    type: 'array',
                    items: {
                      type: 'keyword'
                    }
                  }
                },
                incremental: {
                  total: {
                    type: 'long'
                  },
                  manual: {
                    type: 'long'
                  },
                  scheduled: {
                    type: 'long'
                  },
                  completed: {
                    type: 'long'
                  },
                  errored: {
                    type: 'long'
                  },
                  canceled: {
                    type: 'long'
                  },
                  suspended: {
                    type: 'long'
                  },
                  idle: {
                    type: 'long'
                  },
                  running: {
                    type: 'long'
                  },
                  totalDurationSeconds: {
                    type: 'long'
                  },
                  topErrors: {
                    type: 'array',
                    items: {
                      type: 'keyword'
                    }
                  }
                }
              },
              last7Days: {
                overall: {
                  total: {
                    type: 'long'
                  },
                  manual: {
                    type: 'long'
                  },
                  scheduled: {
                    type: 'long'
                  },
                  completed: {
                    type: 'long'
                  },
                  errored: {
                    type: 'long'
                  },
                  canceled: {
                    type: 'long'
                  },
                  suspended: {
                    type: 'long'
                  },
                  idle: {
                    type: 'long'
                  },
                  running: {
                    type: 'long'
                  },
                  totalDurationSeconds: {
                    type: 'long'
                  },
                  topErrors: {
                    type: 'array',
                    items: {
                      type: 'keyword'
                    }
                  }
                },
                accessControl: {
                  total: {
                    type: 'long'
                  },
                  manual: {
                    type: 'long'
                  },
                  scheduled: {
                    type: 'long'
                  },
                  completed: {
                    type: 'long'
                  },
                  errored: {
                    type: 'long'
                  },
                  canceled: {
                    type: 'long'
                  },
                  suspended: {
                    type: 'long'
                  },
                  idle: {
                    type: 'long'
                  },
                  running: {
                    type: 'long'
                  },
                  totalDurationSeconds: {
                    type: 'long'
                  },
                  topErrors: {
                    type: 'array',
                    items: {
                      type: 'keyword'
                    }
                  }
                },
                full: {
                  total: {
                    type: 'long'
                  },
                  manual: {
                    type: 'long'
                  },
                  scheduled: {
                    type: 'long'
                  },
                  completed: {
                    type: 'long'
                  },
                  errored: {
                    type: 'long'
                  },
                  canceled: {
                    type: 'long'
                  },
                  suspended: {
                    type: 'long'
                  },
                  idle: {
                    type: 'long'
                  },
                  running: {
                    type: 'long'
                  },
                  totalDurationSeconds: {
                    type: 'long'
                  },
                  topErrors: {
                    type: 'array',
                    items: {
                      type: 'keyword'
                    }
                  }
                },
                incremental: {
                  total: {
                    type: 'long'
                  },
                  manual: {
                    type: 'long'
                  },
                  scheduled: {
                    type: 'long'
                  },
                  completed: {
                    type: 'long'
                  },
                  errored: {
                    type: 'long'
                  },
                  canceled: {
                    type: 'long'
                  },
                  suspended: {
                    type: 'long'
                  },
                  idle: {
                    type: 'long'
                  },
                  running: {
                    type: 'long'
                  },
                  totalDurationSeconds: {
                    type: 'long'
                  },
                  topErrors: {
                    type: 'array',
                    items: {
                      type: 'keyword'
                    }
                  }
                }
              }
            }
          }
        }
      }
    },
    async fetch({
      esClient
    }) {
      return await fetchTelemetryMetrics(esClient, log);
    }
  });
  usageCollection.registerCollector(telemetryUsageCollector);
};

/**
 * Fetch the aggregated telemetry metrics
 */
exports.registerTelemetryUsageCollector = registerTelemetryUsageCollector;
const fetchTelemetryMetrics = async (client, log) => {
  try {
    const connectors = await (0, _searchConnectors.collectConnectorStats)(client);
    return {
      connectors
    };
  } catch (error) {
    log.error(`Couldn't fetch telemetry due to error: ${error}`);
    return defaultTelemetryMetrics;
  }
};
exports.fetchTelemetryMetrics = fetchTelemetryMetrics;