"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WorkplaceSearchGateLogic = void 0;
var _kea = require("kea");
var _gated_form_api_logic = require("./gated_form_api_logic");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const WorkplaceSearchGateLogic = exports.WorkplaceSearchGateLogic = (0, _kea.kea)({
  actions: {
    formSubmitRequest: true,
    setAdditionalFeedback: additionalFeedback => ({
      additionalFeedback
    }),
    setFeature: feature => ({
      feature
    }),
    setFeaturesOther: featuresOther => ({
      featuresOther
    }),
    setParticipateInUXLabs: participateInUXLabs => ({
      participateInUXLabs
    })
  },
  connect: {
    actions: [_gated_form_api_logic.UpdateGatedFormDataApiLogic, ['makeRequest as submitGatedFormDataRequest', 'apiSuccess as submitGatedFormSuccess']]
  },
  listeners: ({
    actions,
    values
  }) => ({
    formSubmitRequest: () => {
      if (values.feature) {
        actions.submitGatedFormDataRequest({
          additionalFeedback: values !== null && values !== void 0 && values.additionalFeedback ? values === null || values === void 0 ? void 0 : values.additionalFeedback : null,
          feature: values.feature,
          featuresOther: values !== null && values !== void 0 && values.featuresOther ? values === null || values === void 0 ? void 0 : values.featuresOther : null,
          participateInUXLabs: values === null || values === void 0 ? void 0 : values.participateInUXLabs
        });
      }
    },
    submitGatedFormSuccess: () => {
      window.location.reload();
    }
  }),
  path: ['enterprise_search', 'workplace_search', 'gate_form'],
  reducers: ({}) => ({
    additionalFeedback: [null, {
      // @ts-expect-error upgrade typescript v5.1.6
      setAdditionalFeedback: (_, {
        additionalFeedback
      }) => additionalFeedback !== null && additionalFeedback !== void 0 ? additionalFeedback : undefined
    }],
    feature: ['', {
      // @ts-expect-error upgrade typescript v5.1.6
      setFeature: (_, {
        feature
      }) => feature
    }],
    featuresOther: [null, {
      // @ts-expect-error upgrade typescript v5.1.6
      setFeaturesOther: (_, {
        featuresOther
      }) => featuresOther
    }],
    participateInUXLabs: [null, {
      // @ts-expect-error upgrade typescript v5.1.6
      setParticipateInUXLabs: (_, {
        participateInUXLabs
      }) => participateInUXLabs
    }]
  })
});