"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.stripScheduleSeconds = exports.emptyBlockedWindow = exports.SynchronizationLogic = void 0;
var _kea = require("kea");
var _lodash = require("lodash");
var _moment = _interopRequireDefault(require("moment"));
var _flash_messages = require("../../../../../shared/flash_messages");
var _http = require("../../../../../shared/http");
var _kibana = require("../../../../../shared/kibana");
var _inline_editable_table_logic = require("../../../../../shared/tables/inline_editable_table/inline_editable_table_logic");
var _app_logic = require("../../../../app_logic");
var _routes = require("../../../../routes");
var _constants = require("../../constants");
var _source_logic = require("../../source_logic");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const emptyBlockedWindow = exports.emptyBlockedWindow = {
  jobType: 'full',
  day: 'monday',
  start: '11:00:00Z',
  end: '13:00:00Z'
};
const isIncludeRule = rule => {
  return !!rule.include;
};
const SynchronizationLogic = exports.SynchronizationLogic = (0, _kea.kea)({
  path: ['enterprise_search', 'workplace_search', 'synchronization_logic'],
  actions: {
    setNavigatingBetweenTabs: navigatingBetweenTabs => navigatingBetweenTabs,
    handleSelectedTabChanged: tabId => tabId,
    updateSyncEnabled: enabled => enabled,
    setThumbnailsChecked: checked => checked,
    setSyncFrequency: (type, value, unit) => ({
      type,
      value,
      unit
    }),
    setBlockedTimeWindow: (index, prop, value) => ({
      index,
      prop,
      value
    }),
    setContentExtractionChecked: checked => checked,
    updateServerSettings: body => body,
    setServerSchedule: schedule => schedule,
    removeBlockedWindow: index => index,
    updateFrequencySettings: true,
    updateAssetsAndObjectsSettings: true,
    resetSyncSettings: true,
    addBlockedWindow: true,
    addIndexingRule: rule => rule,
    deleteIndexingRule: rule => rule,
    initAddIndexingRule: rule => ({
      rule
    }),
    initSetIndexingRule: rule => ({
      rule
    }),
    setIndexingRules: indexingRules => indexingRules,
    setIndexingRule: rule => rule
  },
  // @ts-expect-error upgrade typescript v5.1.6
  reducers: ({
    props
  }) => ({
    hasUnsavedIndexingRulesChanges: [false, {
      setIndexingRule: () => true,
      setIndexingRules: () => true,
      addIndexingRule: () => true,
      deleteIndexingRule: () => true,
      resetSyncSettings: () => false,
      updateServerSettings: () => false
    }],
    navigatingBetweenTabs: [false, {
      // @ts-expect-error upgrade typescript v5.1.6
      setNavigatingBetweenTabs: (_, navigatingBetweenTabs) => navigatingBetweenTabs
    }],
    thumbnailsChecked: [props.contentSource.indexing.features.thumbnails.enabled, {
      // @ts-expect-error upgrade typescript v5.1.6
      setThumbnailsChecked: (_, thumbnailsChecked) => thumbnailsChecked,
      resetSyncSettings: () => props.contentSource.indexing.features.thumbnails.enabled
    }],
    contentExtractionChecked: [props.contentSource.indexing.features.contentExtraction.enabled, {
      // @ts-expect-error upgrade typescript v5.1.6
      setContentExtractionChecked: (_, contentExtractionChecked) => contentExtractionChecked,
      resetSyncSettings: () => props.contentSource.indexing.features.contentExtraction.enabled
    }],
    cachedSchedule: [stripScheduleSeconds(props.contentSource.indexing.schedule), {
      // @ts-expect-error upgrade typescript v5.1.6
      setServerSchedule: (_, schedule) => schedule
    }],
    schedule: [stripScheduleSeconds(props.contentSource.indexing.schedule), {
      resetSyncSettings: () => stripScheduleSeconds(props.contentSource.indexing.schedule),
      // @ts-expect-error upgrade typescript v5.1.6
      setServerSchedule: (_, schedule) => schedule,
      // @ts-expect-error upgrade typescript v5.1.6
      setSyncFrequency: (state, {
        type,
        value,
        unit
      }) => {
        let currentValue;
        const schedule = (0, _lodash.cloneDeep)(state);
        const duration = schedule[type];
        switch (unit) {
          case 'days':
            currentValue = _moment.default.duration(duration).days();
            break;
          case 'hours':
            currentValue = _moment.default.duration(duration).hours();
            break;
          default:
            currentValue = _moment.default.duration(duration).minutes();
            break;
        }

        // momentJS doesn't seem to have a way to simply set the minutes/hours/days, so we have
        // to subtract the current value and then add the new value.
        // https://momentjs.com/docs/#/durations/
        schedule[type] = _moment.default.duration(duration).subtract(currentValue, unit).add(value, unit).toISOString();
        return schedule;
      },
      // @ts-expect-error upgrade typescript v5.1.6
      addBlockedWindow: state => {
        const schedule = (0, _lodash.cloneDeep)(state);
        const blockedWindows = schedule.blockedWindows || [];
        blockedWindows.push(emptyBlockedWindow);
        schedule.blockedWindows = blockedWindows;
        return schedule;
      },
      // @ts-expect-error upgrade typescript v5.1.6
      removeBlockedWindow: (state, index) => {
        const schedule = (0, _lodash.cloneDeep)(state);
        const blockedWindows = schedule.blockedWindows;
        blockedWindows.splice(index, 1);
        if (blockedWindows.length > 0) {
          schedule.blockedWindows = blockedWindows;
        } else {
          delete schedule.blockedWindows;
        }
        return schedule;
      },
      // @ts-expect-error upgrade typescript v5.1.6
      setBlockedTimeWindow: (state, {
        index,
        prop,
        value
      }) => {
        const schedule = (0, _lodash.cloneDeep)(state);
        const blockedWindows = schedule.blockedWindows;
        const blockedWindow = blockedWindows[index];
        // @ts-expect-error upgrade typescript v5.1.6
        blockedWindow[prop] = value;
        blockedWindows[index] = blockedWindow;
        schedule.blockedWindows = blockedWindows;
        return schedule;
      }
    }],
    indexingRules: [props.contentSource.indexing.rules.map((rule, index) => ({
      filterType: rule.filterType,
      id: index,
      valueType: isIncludeRule(rule) ? 'include' : 'exclude',
      value: isIncludeRule(rule) ? rule.include : rule.exclude
    })), {
      // @ts-expect-error upgrade typescript v5.1.6
      addIndexingRule: (indexingRules, rule) => [...indexingRules, {
        ...rule,
        // make sure that we get a unique number, in case of multiple deletions and additions
        id: indexingRules.reduce(
        // @ts-expect-error upgrade typescript v5.1.6
        (prev, curr) => curr.id >= prev ? curr.id + 1 : prev, indexingRules.length)
      }],
      // @ts-expect-error upgrade typescript v5.1.6
      deleteIndexingRule: (indexingRules, rule) =>
      // @ts-expect-error upgrade typescript v5.1.6
      indexingRules.filter(currentRule => currentRule.id !== rule.id),
      resetSyncSettings: () => props.contentSource.indexing.rules.map((rule, index) => ({
        filterType: rule.filterType,
        id: index,
        valueType: isIncludeRule(rule) ? 'include' : 'exclude',
        value: isIncludeRule(rule) ? rule.include : rule.exclude
      })),
      // @ts-expect-error upgrade typescript v5.1.6
      setIndexingRules: (_, indexingRules) =>
      // @ts-expect-error upgrade typescript v5.1.6
      indexingRules.map((val, index) => ({
        ...val,
        id: index
      })),
      // @ts-expect-error upgrade typescript v5.1.6
      setIndexingRule: (state, rule) =>
      // @ts-expect-error upgrade typescript v5.1.6
      state.map(currentRule => currentRule.id === rule.id ? rule : currentRule)
    }]
  }),
  selectors: ({
    selectors
  }) => ({
    hasUnsavedAssetsAndObjectsChanges: [() => [selectors.thumbnailsChecked, selectors.contentExtractionChecked, selectors.hasUnsavedIndexingRulesChanges, (_, props) => props.contentSource], (thumbnailsChecked, contentExtractionChecked, hasUnsavedIndexingRulesChanges, contentSource) => {
      const {
        indexing: {
          features: {
            thumbnails: {
              enabled: thumbnailsEnabled
            },
            contentExtraction: {
              enabled: contentExtractionEnabled
            }
          }
        }
      } = contentSource;
      return thumbnailsChecked !== thumbnailsEnabled || contentExtractionChecked !== contentExtractionEnabled || hasUnsavedIndexingRulesChanges;
    }],
    hasUnsavedFrequencyChanges: [() => [selectors.cachedSchedule, selectors.schedule], (cachedSchedule, schedule) => !(0, _lodash.isEqual)(cachedSchedule, schedule)],
    indexingRulesForAPI: [() => [selectors.indexingRules], indexingRules => indexingRules.map(indexingRule => indexingRuleToApiFormat(indexingRule))]
  }),
  listeners: ({
    actions,
    values,
    props
  }) => ({
    handleSelectedTabChanged: async (tabId, breakpoint) => {
      const {
        isOrganization
      } = _app_logic.AppLogic.values;
      const {
        id: sourceId
      } = props.contentSource;
      const path = tabId === 'source_sync_frequency' ? (0, _routes.getContentSourcePath)(_routes.SYNC_FREQUENCY_PATH, sourceId, isOrganization) : (0, _routes.getContentSourcePath)(_routes.BLOCKED_TIME_WINDOWS_PATH, sourceId, isOrganization);

      // This method is needed because the shared `UnsavedChangesPrompt` component is triggered
      // when navigating between tabs. We set a boolean flag that tells the prompt there are no
      // unsaved changes when navigating between the tabs and reset it one the transition is complete
      // in order to restore the intended functionality when navigating away with unsaved changes.
      actions.setNavigatingBetweenTabs(true);
      await breakpoint();
      _kibana.KibanaLogic.values.navigateToUrl(path);
      actions.setNavigatingBetweenTabs(false);
    },
    initAddIndexingRule: async ({
      rule
    }) => {
      const {
        id: sourceId
      } = props.contentSource;
      const route = `/internal/workplace_search/org/sources/${sourceId}/indexing_rules/validate`;
      try {
        var _response$rules$;
        const response = await _http.HttpLogic.values.http.post(route, {
          body: JSON.stringify({
            rules: [indexingRuleToApiFormat(rule)]
          })
        });
        const error = (_response$rules$ = response.rules[0]) === null || _response$rules$ === void 0 ? void 0 : _response$rules$.error;
        const tableLogic = (0, _inline_editable_table_logic.InlineEditableTableLogic)({
          instanceId: 'IndexingRulesTable'
        });
        if (error) {
          tableLogic.actions.setRowErrors([error]);
        } else {
          actions.addIndexingRule(rule);
        }
        tableLogic.actions.doneEditing();
      } catch (e) {
        (0, _flash_messages.flashAPIErrors)(e);
      }
    },
    initSetIndexingRule: async ({
      rule
    }) => {
      const {
        id: sourceId
      } = props.contentSource;
      const route = `/internal/workplace_search/org/sources/${sourceId}/indexing_rules/validate`;
      try {
        var _response$rules$2;
        const response = await _http.HttpLogic.values.http.post(route, {
          body: JSON.stringify({
            rules: [indexingRuleToApiFormat(rule)]
          })
        });
        const error = (_response$rules$2 = response.rules[0]) === null || _response$rules$2 === void 0 ? void 0 : _response$rules$2.error;
        const tableLogic = (0, _inline_editable_table_logic.InlineEditableTableLogic)({
          instanceId: 'IndexingRulesTable'
        });
        if (error) {
          tableLogic.actions.setRowErrors([error]);
        } else {
          actions.setIndexingRule(rule);
        }
        tableLogic.actions.doneEditing();
      } catch (e) {
        (0, _flash_messages.flashAPIErrors)(e);
      }
    },
    updateSyncEnabled: async enabled => {
      actions.updateServerSettings({
        content_source: {
          indexing: {
            enabled
          }
        }
      });
    },
    updateAssetsAndObjectsSettings: () => {
      actions.updateServerSettings({
        content_source: {
          indexing: {
            features: {
              content_extraction: {
                enabled: values.contentExtractionChecked
              },
              thumbnails: {
                enabled: values.thumbnailsChecked
              }
            },
            rules: values.indexingRulesForAPI
          }
        }
      });
    },
    updateFrequencySettings: () => {
      actions.updateServerSettings({
        content_source: {
          indexing: {
            schedule: {
              full: values.schedule.full,
              incremental: values.schedule.incremental,
              delete: values.schedule.delete,
              blocked_windows: formatBlockedWindowsForServer(values.schedule.blockedWindows)
            }
          }
        }
      });
    },
    updateServerSettings: async body => {
      const {
        id: sourceId
      } = props.contentSource;
      const route = `/internal/workplace_search/org/sources/${sourceId}/settings`;
      try {
        const response = await _http.HttpLogic.values.http.patch(route, {
          body: JSON.stringify(body)
        });
        _source_logic.SourceLogic.actions.setContentSource(response);
        SynchronizationLogic.actions.setServerSchedule(response.indexing.schedule);
        (0, _flash_messages.flashSuccessToast)(_constants.SYNC_SETTINGS_UPDATED_MESSAGE);
      } catch (e) {
        (0, _flash_messages.flashAPIErrors)(e);
      }
    }
  })
});
const SECONDS_IN_MS = 1000;
const getDurationMS = time => _moment.default.duration(time).seconds() * SECONDS_IN_MS;
const getISOStringWithoutSeconds = time => _moment.default.duration(time).subtract(getDurationMS(time)).toISOString();

// The API allows for setting schedule values with seconds. The UI feature does not allow for setting
// values with seconds. This function strips the seconds from the schedule values for equality checks
// to determine if the user has unsaved changes.
const stripScheduleSeconds = schedule => {
  const _schedule = (0, _lodash.cloneDeep)(schedule);
  const {
    full,
    incremental,
    delete: _delete,
    permissions
  } = _schedule;
  _schedule.full = getISOStringWithoutSeconds(full);
  _schedule.incremental = getISOStringWithoutSeconds(incremental);
  _schedule.delete = getISOStringWithoutSeconds(_delete);
  if (permissions) _schedule.permissions = getISOStringWithoutSeconds(permissions);
  return _schedule;
};
exports.stripScheduleSeconds = stripScheduleSeconds;
const formatBlockedWindowsForServer = blockedWindows => {
  if (!blockedWindows || blockedWindows.length < 1) return [];
  return blockedWindows.map(({
    jobType,
    day,
    start,
    end
  }) => ({
    job_type: jobType,
    day,
    start,
    end
  }));
};
const indexingRuleToApiFormat = indexingRule => {
  const {
    valueType,
    filterType,
    value
  } = indexingRule;
  return valueType === 'include' ? {
    filter_type: filterType,
    include: value
  } : {
    filter_type: filterType,
    exclude: value
  };
};