"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SourceInfoCard = void 0;
var _react = _interopRequireDefault(require("react"));
var _moment = _interopRequireDefault(require("moment"));
var _eui = require("@elastic/eui");
var _source_icon = require("../../../components/shared/source_icon");
var _constants = require("../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SourceInfoCard = ({
  contentSource: {
    createdAt,
    name,
    serviceType,
    isFederatedSource,
    mainIcon
  }
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  gutterSize: "none",
  justifyContent: "spaceBetween",
  alignItems: "center"
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  gutterSize: "s",
  justifyContent: "flexStart",
  alignItems: "center"
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: null
}, /*#__PURE__*/_react.default.createElement(_source_icon.SourceIcon, {
  serviceType: serviceType,
  name: name,
  iconAsBase64: mainIcon,
  size: "l"
})), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
  size: "s"
}, /*#__PURE__*/_react.default.createElement("h1", null, name)))), isFederatedSource && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  gutterSize: "none",
  justifyContent: "flexStart"
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: null
}, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
  size: "xs"
}), /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
  iconType: "online",
  iconSide: "left"
}, _constants.REMOTE_SOURCE_LABEL)))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
  textAlign: "right",
  size: "s"
}, /*#__PURE__*/_react.default.createElement("strong", null, _constants.CREATED_LABEL), (0, _moment.default)(createdAt).format('MMMM D, YYYY')), isFederatedSource && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  gutterSize: "xs",
  justifyContent: "flexEnd",
  alignItems: "center"
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: null
}, /*#__PURE__*/_react.default.createElement("strong", null, _constants.STATUS_LABEL)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: null
}, /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
  color: "success"
}, _constants.READY_TEXT)))));
exports.SourceInfoCard = SourceInfoCard;