"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.dataTypeOptions = exports.SchemaLogic = void 0;
var _kea = require("kea");
var _lodash = require("lodash");
var _i18n = require("@kbn/i18n");
var _operations = require("../../../../../shared/constants/operations");
var _flash_messages = require("../../../../../shared/flash_messages");
var _handle_api_errors = require("../../../../../shared/flash_messages/handle_api_errors");
var _http = require("../../../../../shared/http");
var _types = require("../../../../../shared/schema/types");
var _app_logic = require("../../../../app_logic");
var _source_logic = require("../../source_logic");
var _constants = require("./constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const dataTypeOptions = exports.dataTypeOptions = [{
  value: 'text',
  text: 'Text'
}, {
  value: 'date',
  text: 'Date'
}, {
  value: 'number',
  text: 'Number'
}, {
  value: 'geolocation',
  text: 'Geo Location'
}];
const SchemaLogic = exports.SchemaLogic = (0, _kea.kea)({
  actions: {
    onInitializeSchema: schemaProps => schemaProps,
    onInitializeSchemaFieldErrors: fieldCoercionErrorsProps => fieldCoercionErrorsProps,
    onSchemaSetSuccess: schemaProps => schemaProps,
    onSchemaSetFormErrors: errors => errors,
    updateNewFieldType: newFieldType => newFieldType,
    onFieldUpdate: ({
      schema,
      formUnchanged
    }) => ({
      schema,
      formUnchanged
    }),
    onIndexingComplete: numDocumentsWithErrors => numDocumentsWithErrors,
    resetMostRecentIndexJob: emptyReindexJob => emptyReindexJob,
    setFieldName: rawFieldName => rawFieldName,
    setFilterValue: filterValue => filterValue,
    openAddFieldModal: () => true,
    closeAddFieldModal: () => true,
    resetSchemaState: () => true,
    initializeSchema: () => true,
    initializeSchemaFieldErrors: (activeReindexJobId, sourceId) => ({
      activeReindexJobId,
      sourceId
    }),
    addNewField: (fieldName, newFieldType) => ({
      fieldName,
      newFieldType
    }),
    updateExistingFieldType: (fieldName, newFieldType) => ({
      fieldName,
      newFieldType
    }),
    updateFields: () => true,
    setServerField: (updatedSchema, operation) => ({
      updatedSchema,
      operation
    })
  },
  reducers: {
    dataTypeOptions: [dataTypeOptions],
    sourceId: ['', {
      // @ts-expect-error upgrade typescript v5.1.6
      onInitializeSchema: (_, {
        sourceId
      }) => sourceId
    }],
    activeSchema: [{}, {
      // @ts-expect-error upgrade typescript v5.1.6
      onInitializeSchema: (_, {
        schema
      }) => schema,
      // @ts-expect-error upgrade typescript v5.1.6
      onSchemaSetSuccess: (_, {
        schema
      }) => schema,
      // @ts-expect-error upgrade typescript v5.1.6
      onFieldUpdate: (_, {
        schema
      }) => schema
    }],
    serverSchema: [{}, {
      // @ts-expect-error upgrade typescript v5.1.6
      onInitializeSchema: (_, {
        schema
      }) => schema,
      // @ts-expect-error upgrade typescript v5.1.6
      onSchemaSetSuccess: (_, {
        schema
      }) => schema
    }],
    mostRecentIndexJob: [{}, {
      // @ts-expect-error upgrade typescript v5.1.6
      onInitializeSchema: (_, {
        mostRecentIndexJob
      }) => mostRecentIndexJob,
      // @ts-expect-error upgrade typescript v5.1.6
      resetMostRecentIndexJob: (_, emptyReindexJob) => emptyReindexJob,
      // @ts-expect-error upgrade typescript v5.1.6
      onSchemaSetSuccess: (_, {
        mostRecentIndexJob
      }) => mostRecentIndexJob,
      // @ts-expect-error upgrade typescript v5.1.6
      onIndexingComplete: (state, numDocumentsWithErrors) => ({
        ...state,
        numDocumentsWithErrors,
        percentageComplete: 100,
        hasErrors: numDocumentsWithErrors > 0,
        isActive: false
      }),
      // @ts-expect-error upgrade typescript v5.1.6
      updateFields: state => ({
        ...state,
        percentageComplete: 0
      })
    }],
    newFieldType: [_types.SchemaType.Text, {
      // @ts-expect-error upgrade typescript v5.1.6
      updateNewFieldType: (_, newFieldType) => newFieldType,
      onSchemaSetSuccess: () => _types.SchemaType.Text
    }],
    addFieldFormErrors: [null, {
      onSchemaSetSuccess: () => null,
      closeAddFieldModal: () => null,
      // @ts-expect-error upgrade typescript v5.1.6
      onSchemaSetFormErrors: (_, addFieldFormErrors) => addFieldFormErrors
    }],
    filterValue: ['', {
      // @ts-expect-error upgrade typescript v5.1.6
      setFilterValue: (_, filterValue) => filterValue
    }],
    formUnchanged: [true, {
      onSchemaSetSuccess: () => true,
      // @ts-expect-error upgrade typescript v5.1.6
      onFieldUpdate: (_, {
        formUnchanged
      }) => formUnchanged
    }],
    showAddFieldModal: [false, {
      onSchemaSetSuccess: () => false,
      openAddFieldModal: () => true,
      closeAddFieldModal: () => false
    }],
    dataLoading: [true, {
      onSchemaSetSuccess: () => false,
      onInitializeSchema: () => false,
      resetSchemaState: () => true
    }],
    rawFieldName: ['', {
      // @ts-expect-error upgrade typescript v5.1.6
      setFieldName: (_, rawFieldName) => rawFieldName,
      onSchemaSetSuccess: () => ''
    }],
    fieldCoercionErrors: [{}, {
      // @ts-expect-error upgrade typescript v5.1.6
      onInitializeSchemaFieldErrors: (_, {
        fieldCoercionErrors
      }) => fieldCoercionErrors
    }]
  },
  selectors: ({
    selectors
  }) => ({
    filteredSchemaFields: [() => [selectors.activeSchema, selectors.filterValue], (activeSchema, filterValue) => {
      const filteredSchema = {};
      Object.keys(activeSchema).filter(x => x.includes(filterValue)).forEach(k => filteredSchema[k] = activeSchema[k]);
      return filteredSchema;
    }]
  }),
  listeners: ({
    actions,
    values
  }) => ({
    initializeSchema: async () => {
      const {
        isOrganization
      } = _app_logic.AppLogic.values;
      const {
        http
      } = _http.HttpLogic.values;
      const {
        contentSource: {
          id: sourceId
        }
      } = _source_logic.SourceLogic.values;
      const route = isOrganization ? `/internal/workplace_search/org/sources/${sourceId}/schemas` : `/internal/workplace_search/account/sources/${sourceId}/schemas`;
      try {
        const response = await http.get(route);
        // TODO: fix
        // @ts-expect-error TS2783
        actions.onInitializeSchema({
          sourceId,
          ...response
        });
      } catch (e) {
        (0, _flash_messages.flashAPIErrors)(e);
      }
    },
    initializeSchemaFieldErrors: async ({
      activeReindexJobId,
      sourceId
    }) => {
      const {
        isOrganization
      } = _app_logic.AppLogic.values;
      const {
        http
      } = _http.HttpLogic.values;
      const route = isOrganization ? `/internal/workplace_search/org/sources/${sourceId}/reindex_job/${activeReindexJobId}` : `/internal/workplace_search/account/sources/${sourceId}/reindex_job/${activeReindexJobId}`;
      try {
        await actions.initializeSchema();
        const response = await http.get(route);
        actions.onInitializeSchemaFieldErrors({
          fieldCoercionErrors: response.fieldCoercionErrors
        });
      } catch (e) {
        (0, _flash_messages.setErrorMessage)(_constants.SCHEMA_FIELD_ERRORS_ERROR_MESSAGE);
      }
    },
    addNewField: ({
      fieldName,
      newFieldType
    }) => {
      if (fieldName in values.activeSchema) {
        window.scrollTo(0, 0);
        actions.onSchemaSetFormErrors([_i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.contentSource.schema.newFieldExists.message', {
          defaultMessage: 'New field already exists: {fieldName}.',
          values: {
            fieldName
          }
        })]);
      } else {
        const schema = (0, _lodash.cloneDeep)(values.activeSchema);
        schema[fieldName] = newFieldType;
        actions.setServerField(schema, _operations.ADD);
      }
    },
    updateExistingFieldType: ({
      fieldName,
      newFieldType
    }) => {
      const schema = (0, _lodash.cloneDeep)(values.activeSchema);
      schema[fieldName] = newFieldType;
      actions.onFieldUpdate({
        schema,
        formUnchanged: (0, _lodash.isEqual)(values.serverSchema, schema)
      });
    },
    updateFields: () => actions.setServerField(values.activeSchema, _operations.UPDATE),
    setServerField: async ({
      updatedSchema,
      operation
    }) => {
      const {
        isOrganization
      } = _app_logic.AppLogic.values;
      const {
        http
      } = _http.HttpLogic.values;
      const isAdding = operation === _operations.ADD;
      const {
        sourceId
      } = values;
      const successMessage = isAdding ? _constants.SCHEMA_FIELD_ADDED_MESSAGE : _constants.SCHEMA_UPDATED_MESSAGE;
      const route = isOrganization ? `/internal/workplace_search/org/sources/${sourceId}/schemas` : `/internal/workplace_search/account/sources/${sourceId}/schemas`;
      const emptyReindexJob = {
        percentageComplete: 100,
        numDocumentsWithErrors: 0,
        activeReindexJobId: '',
        isActive: false
      };
      actions.resetMostRecentIndexJob(emptyReindexJob);
      try {
        const response = await http.post(route, {
          body: JSON.stringify({
            ...updatedSchema
          })
        });
        actions.onSchemaSetSuccess(response);
        (0, _flash_messages.flashSuccessToast)(successMessage);
      } catch (e) {
        window.scrollTo(0, 0);
        if (isAdding) {
          var _e$body, _e$body$attributes;
          // We expect body.attributes.errors to be a string[] for actions.onSchemaSetFormErrors
          const message = (e === null || e === void 0 ? void 0 : (_e$body = e.body) === null || _e$body === void 0 ? void 0 : (_e$body$attributes = _e$body.attributes) === null || _e$body$attributes === void 0 ? void 0 : _e$body$attributes.errors) || [_handle_api_errors.defaultErrorMessage];
          actions.onSchemaSetFormErrors(message);
        } else {
          (0, _flash_messages.flashAPIErrors)(e);
        }
      }
    },
    resetMostRecentIndexJob: () => {
      (0, _flash_messages.clearFlashMessages)();
    },
    resetSchemaState: () => {
      (0, _flash_messages.clearFlashMessages)();
    }
  })
});