"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SchemaChangeErrors = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _kea = require("kea");
var _schema = require("../../../../../shared/schema");
var _view_content_header = require("../../../../components/shared/view_content_header");
var _constants = require("../../../../constants");
var _source_layout = require("../source_layout");
var _constants2 = require("./constants");
var _schema_logic = require("./schema_logic");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SchemaChangeErrors = () => {
  const {
    activeReindexJobId,
    sourceId
  } = (0, _reactRouterDom.useParams)();
  const {
    initializeSchemaFieldErrors
  } = (0, _kea.useActions)(_schema_logic.SchemaLogic);
  const {
    fieldCoercionErrors,
    serverSchema
  } = (0, _kea.useValues)(_schema_logic.SchemaLogic);
  (0, _react.useEffect)(() => {
    initializeSchemaFieldErrors(activeReindexJobId, sourceId);
  }, []);
  return /*#__PURE__*/_react.default.createElement(_source_layout.SourceLayout, {
    pageChrome: [_constants.NAV.SCHEMA, _constants2.SCHEMA_ERRORS_HEADING],
    pageViewTelemetry: "source_schema"
  }, /*#__PURE__*/_react.default.createElement(_view_content_header.ViewContentHeader, {
    title: _constants2.SCHEMA_ERRORS_HEADING
  }), /*#__PURE__*/_react.default.createElement(_schema.SchemaErrorsAccordion, {
    fieldCoercionErrors: fieldCoercionErrors,
    schema: serverSchema
  }));
};
exports.SchemaChangeErrors = SchemaChangeErrors;