"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Overview = void 0;
var _react = _interopRequireWildcard(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _constants = require("../../../../shared/constants");
var _doc_links = require("../../../../shared/doc_links");
var _react_router_helpers = require("../../../../shared/react_router_helpers");
var _app_logic = require("../../../app_logic");
var _supports_acl = _interopRequireDefault(require("../../../assets/supports_acl.svg"));
var _component_loader = require("../../../components/shared/component_loader");
var _license_badge = require("../../../components/shared/license_badge");
var _status_item = require("../../../components/shared/status_item");
var _view_content_header = require("../../../components/shared/view_content_header");
var _constants2 = require("../../../constants");
var _routes = require("../../../routes");
var _constants3 = require("../constants");
var _source_logic = require("../source_logic");
var _custom_source_deployment = require("./custom_source_deployment");
var _source_layout = require("./source_layout");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const Overview = () => {
  const {
    contentSource
  } = (0, _kea.useValues)(_source_logic.SourceLogic);
  const {
    initializeSourceSynchronization
  } = (0, _kea.useActions)(_source_logic.SourceLogic);
  const {
    isOrganization
  } = (0, _kea.useValues)(_app_logic.AppLogic);
  const {
    id,
    summary,
    activities,
    groups,
    details,
    custom,
    licenseSupportsPermissions,
    serviceTypeSupportsPermissions,
    indexPermissions,
    hasPermissions,
    isFederatedSource,
    isIndexedSource,
    serviceType,
    baseServiceType
  } = contentSource;
  const [isSyncing, setIsSyncing] = (0, _react.useState)(false);
  const [isModalVisible, setIsModalVisible] = (0, _react.useState)(false);
  const closeModal = () => setIsModalVisible(false);
  const handleSyncClick = () => setIsModalVisible(true);
  const showSyncTriggerCallout = !custom && isIndexedSource && isOrganization;
  const onSyncConfirm = () => {
    initializeSourceSynchronization(id);
    setIsSyncing(true);
    closeModal();
  };
  const DocumentSummary = () => {
    let totalDocuments = 0;
    const tableContent = summary === null || summary === void 0 ? void 0 : summary.map((item, index) => {
      totalDocuments += item.count;
      return item.count > 0 && /*#__PURE__*/_react.default.createElement(_eui.EuiTableRow, {
        key: index,
        "data-test-subj": "DocumentSummaryRow"
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiTableRowCell, null, item.type), /*#__PURE__*/_react.default.createElement(_eui.EuiTableRowCell, null, item.count.toLocaleString('en-US')));
    });
    const emptyState = /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
      hasShadow: false,
      color: "subdued",
      paddingSize: "l",
      "data-test-subj": "EmptyDocumentSummary"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
      title: /*#__PURE__*/_react.default.createElement("h2", null, _constants3.SOURCES_NO_CONTENT_TITLE),
      iconType: "documents",
      iconColor: "subdued"
    })));
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "xs"
    }, /*#__PURE__*/_react.default.createElement("h3", null, _constants3.CONTENT_SUMMARY_TITLE)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s"
    }), !summary && /*#__PURE__*/_react.default.createElement(_component_loader.ComponentLoader, {
      text: _constants3.CONTENT_SUMMARY_LOADING_TEXT
    }), !!summary && (totalDocuments === 0 ? emptyState : /*#__PURE__*/_react.default.createElement(_eui.EuiTable, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTableHeader, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTableHeaderCell, null, _constants3.CONTENT_TYPE_HEADER), /*#__PURE__*/_react.default.createElement(_eui.EuiTableHeaderCell, null, _constants3.ITEMS_HEADER)), /*#__PURE__*/_react.default.createElement(_eui.EuiTableBody, null, tableContent, /*#__PURE__*/_react.default.createElement(_eui.EuiTableRow, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTableRowCell, null, /*#__PURE__*/_react.default.createElement("strong", null, _constants3.TOTAL_DOCUMENTS_LABEL)), /*#__PURE__*/_react.default.createElement(_eui.EuiTableRowCell, null, /*#__PURE__*/_react.default.createElement("strong", null, totalDocuments.toLocaleString('en-US'))))))));
  };
  const ActivitySummary = () => {
    const emptyState = /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
      paddingSize: "l",
      hasShadow: false,
      color: "subdued",
      "data-test-subj": "EmptyActivitySummary"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
      title: /*#__PURE__*/_react.default.createElement("h2", null, _constants3.EMPTY_ACTIVITY_TITLE),
      iconType: "clock",
      iconColor: "subdued"
    })));
    const activitiesTable = /*#__PURE__*/_react.default.createElement(_eui.EuiTable, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTableHeader, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTableHeaderCell, null, _constants3.EVENT_HEADER), !custom && /*#__PURE__*/_react.default.createElement(_eui.EuiTableHeaderCell, null, _constants3.STATUS_HEADER), /*#__PURE__*/_react.default.createElement(_eui.EuiTableHeaderCell, {
      align: "right"
    }, _constants3.TIME_HEADER)), /*#__PURE__*/_react.default.createElement(_eui.EuiTableBody, null, activities.map(({
      details: activityDetails,
      event,
      time,
      status
    }, i) => /*#__PURE__*/_react.default.createElement(_eui.EuiTableRow, {
      key: i
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTableRowCell, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s"
    }, event)), !custom && /*#__PURE__*/_react.default.createElement(_eui.EuiTableRowCell, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s"
    }, /*#__PURE__*/_react.default.createElement("small", null, status, " ", activityDetails && /*#__PURE__*/_react.default.createElement(_status_item.StatusItem, {
      details: activityDetails
    })))), /*#__PURE__*/_react.default.createElement(_eui.EuiTableRowCell, {
      align: "right"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s"
    }, /*#__PURE__*/_react.default.createElement("small", null, time)))))));
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "xs"
    }, /*#__PURE__*/_react.default.createElement("h4", null, _constants2.RECENT_ACTIVITY_TITLE)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s"
    }), activities.length === 0 ? emptyState : activitiesTable);
  };
  const groupsSummary = /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h5", null, _constants3.GROUP_ACCESS_TITLE)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiListGroup, {
    flush: true,
    maxWidth: false,
    "data-test-subj": "GroupsSummary"
  }, groups.map((group, index) => /*#__PURE__*/_react.default.createElement(_react_router_helpers.EuiListGroupItemTo, {
    label: group.name,
    key: index,
    to: (0, _routes.getGroupPath)(group.id),
    "data-test-subj": "SourceGroupLink"
  })))));
  const detailsSummary = /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h3", null, _constants3.CONFIGURATION_TITLE)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, details.map((detail, index) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    wrap: true,
    gutterSize: "s",
    alignItems: "center",
    justifyContent: "spaceBetween",
    key: index
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement("strong", null, detail.title)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, detail.description))))));
  const documentPermissions = /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h4", null, _constants3.DOCUMENT_PERMISSIONS_TITLE)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: _supports_acl.default,
    size: "l",
    color: "primary"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("strong", null, _constants3.DOCUMENT_PERMISSIONS_TEXT))))));
  const documentPermissionsDisabled = /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h4", null, _constants3.DOCUMENT_PERMISSIONS_TITLE)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    color: "subdued",
    "data-test-subj": "DocumentPermissionsDisabled"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    wrap: true,
    gutterSize: "m",
    alignItems: "center",
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    size: "l",
    type: "iInCircle",
    color: "subdued"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("strong", null, _constants3.DOCUMENT_PERMISSIONS_DISABLED_TEXT)), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.enterpriseSearch.workplaceSearch.sources.learnMore.text",
    defaultMessage: "{learnMoreLink} about permissions",
    values: {
      learnMoreLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        target: "_blank",
        href: _doc_links.docLinks.workplaceSearchDocumentPermissions
      }, _constants3.LEARN_MORE_LINK)
    }
  })))))));
  const sourceStatus = /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h6", null, _constants3.STATUS_HEADER)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    size: "l",
    type: "checkInCircleFilled",
    color: "success"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("strong", null, _constants3.STATUS_HEADING)), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("p", null, _constants3.STATUS_TEXT))))));
  const permissionsStatus = /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    color: "subdued",
    "data-test-subj": "PermissionsStatus"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h6", null, /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
    color: "subdued"
  }, _constants3.STATUS_HEADING))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    size: "xl",
    type: "dot",
    color: "warning"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("strong", null, _constants3.ADDITIONAL_CONFIG_HEADING)), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.enterpriseSearch.workplaceSearch.sources.externalIdentities.text",
    defaultMessage: "The {externalIdentitiesLink} must be used to configure user access mappings. Read the guide to learn more.",
    values: {
      externalIdentitiesLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        target: "_blank",
        href: _doc_links.docLinks.workplaceSearchExternalIdentities
      }, _constants3.EXTERNAL_IDENTITIES_LINK)
    }
  }))))));
  const customSourceDeployment = /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h6", null, _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.deployment.title', {
    defaultMessage: 'Deployment'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_custom_source_deployment.CustomSourceDeployment, {
    source: contentSource,
    baseServiceType: baseServiceType,
    small: true
  }));
  const documentPermssionsLicenseLocked = /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    alignItems: "center",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("span", null, _constants3.DOCUMENT_PERMISSIONS_TITLE))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_license_badge.LicenseBadge, null))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("p", null, _constants3.DOC_PERMISSIONS_DESCRIPTION)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    target: "_blank",
    href: _doc_links.docLinks.licenseManagement
  }, _constants3.LEARN_CUSTOM_FEATURES_BUTTON))));
  const syncTriggerCallout = /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h5", null, _constants3.SOURCE_SYNCHRONIZATION_TITLE)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    fill: true,
    isLoading: isSyncing,
    onClick: handleSyncClick,
    "data-test-subj": "SyncButton"
  }, _constants3.SOURCE_SYNCHRONIZATION_BUTTON_LABEL), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.enterpriseSearch.workplaceSearch.sources.synchronizationCallout",
    defaultMessage: "Configure {syncFrequencyLink} or {blockTimeWindowsLink}.",
    values: {
      syncFrequencyLink: /*#__PURE__*/_react.default.createElement(_react_router_helpers.EuiLinkTo, {
        to: (0, _routes.getContentSourcePath)(_routes.SYNC_FREQUENCY_PATH, id, isOrganization)
      }, _constants3.SOURCE_SYNC_FREQUENCY_LINK_LABEL),
      blockTimeWindowsLink: /*#__PURE__*/_react.default.createElement(_react_router_helpers.EuiLinkTo, {
        to: (0, _routes.getContentSourcePath)(_routes.BLOCKED_TIME_WINDOWS_PATH, id, isOrganization)
      }, _constants3.SOURCE_BLOCKED_TIME_WINDOWS_LINK_LABEL)
    }
  }))));
  const syncConfirmModal = /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
    title: _constants3.SOURCE_SYNC_CONFIRM_TITLE,
    onCancel: closeModal,
    onConfirm: onSyncConfirm,
    cancelButtonText: _constants.CANCEL_BUTTON_LABEL,
    confirmButtonText: _constants.START_BUTTON_LABEL,
    defaultFocusedButton: "confirm"
  }, /*#__PURE__*/_react.default.createElement("p", null, _constants3.SOURCE_SYNC_CONFIRM_MESSAGE));
  return /*#__PURE__*/_react.default.createElement(_source_layout.SourceLayout, {
    pageViewTelemetry: "source_overview"
  }, /*#__PURE__*/_react.default.createElement(_view_content_header.ViewContentHeader, {
    title: _constants3.SOURCE_OVERVIEW_TITLE
  }), isModalVisible && syncConfirmModal, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xl",
    alignItems: "flexStart"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 8
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xl",
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(DocumentSummary, {
    "data-test-subj": "DocumentSummary"
  })), !isFederatedSource && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(ActivitySummary, {
    "data-test-subj": "ActivitySummary"
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 7
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m",
    direction: "column"
  }, showSyncTriggerCallout && syncTriggerCallout, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, groups.length > 0 && groupsSummary), details.length > 0 && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, detailsSummary), !custom && serviceTypeSupportsPermissions && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, indexPermissions && !hasPermissions && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, permissionsStatus), indexPermissions && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, documentPermissions), !indexPermissions && isOrganization && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, documentPermissionsDisabled)), custom && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, sourceStatus), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, customSourceDeployment), !licenseSupportsPermissions && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, documentPermssionsLicenseLocked))))), serviceType === 'external' && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    size: "s",
    color: "primary",
    iconType: "email",
    title: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      href: "https://www.elastic.co/kibana/feedback",
      external: true
    }, _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.sources.feedbackCallOutText', {
      defaultMessage: 'Have feedback about deploying a connector package? Let us know.'
    }))
  })))));
};
exports.Overview = Overview;