"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DownloadDiagnosticsButton = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _http = require("../../../../shared/http");
var _app_logic = require("../../../app_logic");
var _source_logic = require("../source_logic");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DownloadDiagnosticsButton = ({
  label
}) => {
  const {
    http
  } = (0, _kea.useValues)(_http.HttpLogic);
  const {
    isOrganization
  } = (0, _kea.useValues)(_app_logic.AppLogic);
  const {
    contentSource: {
      id,
      serviceType
    },
    buttonLoading
  } = (0, _kea.useValues)(_source_logic.SourceLogic);
  const diagnosticsPath = isOrganization ? http.basePath.prepend(`/internal/workplace_search/org/sources/${id}/download_diagnostics`) : http.basePath.prepend(`/internal/workplace_search/account/sources/${id}/download_diagnostics`);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    target: "_blank",
    href: diagnosticsPath,
    isLoading: buttonLoading,
    "data-test-subj": "DownloadDiagnosticsButton",
    download: `${id}_${serviceType}_${Date.now()}_diagnostics.json`
  }, label);
};
exports.DownloadDiagnosticsButton = DownloadDiagnosticsButton;