"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TitleField = void 0;
var _react = _interopRequireDefault(require("react"));
var _classnames = _interopRequireDefault(require("classnames"));
var _constants = require("./constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TitleField = ({
  result,
  titleField,
  titleFieldHover
}) => {
  const title = titleField ? result[titleField] : '';
  const titleDisplay = Array.isArray(title) ? title.join(', ') : title;
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "TitleField",
    className: (0, _classnames.default)('example-result-content__title', {
      'example-result-field-hover': titleFieldHover
    })
  }, titleField ? /*#__PURE__*/_react.default.createElement("div", {
    className: "eui-textTruncate",
    "data-test-subj": "CustomTitleLabel"
  }, titleDisplay) : /*#__PURE__*/_react.default.createElement("span", {
    className: "example-result-content-placeholder",
    "data-test-subj": "DefaultTitleLabel"
  }, _constants.TITLE_LABEL));
};
exports.TitleField = TitleField;