"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CustomSourceDeployment = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _react_router_helpers = require("../../../../shared/react_router_helpers");
var _constants = require("../../../constants");
var _routes = require("../../../routes");
var _source_data = require("../source_data");
var _source_identifier = require("./source_identifier");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CustomSourceDeployment = ({
  source,
  baseServiceType,
  small = false
}) => {
  const {
    name,
    id
  } = source;
  const sourceData = (0, _source_data.getSourceData)('custom', baseServiceType);
  if (!sourceData) {
    return null;
  }
  const {
    configuration: {
      documentationUrl,
      githubRepository
    }
  } = sourceData;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: small ? 'm' : 'l',
    hasShadow: false,
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: small ? 's' : 'm'
  }, githubRepository ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    "data-test-subj": "GithubRepositoryLink",
    id: "xpack.enterpriseSearch.workplaceSearch.customSourceDeployment.preconfiguredRepositoryInstructions",
    defaultMessage: "Set up your connector by cloning the {githubRepositoryLink}",
    values: {
      githubRepositoryLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        target: "_blank",
        href: `https://github.com/${githubRepository}`
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.enterpriseSearch.workplaceSearch.customSourceDeployment.repositoryLinkLabel",
        defaultMessage: "{name} connector repository",
        values: {
          name
        }
      }))
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    "data-test-subj": "PreconfiguredDocumentationLink",
    id: "xpack.enterpriseSearch.workplaceSearch.customSourceDeployment.preconfiguredDocumentationHelpText",
    defaultMessage: "Review the {documentationLink} and deploy the connector package to be self managed on the infrastructure of your choice.",
    values: {
      documentationLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        target: "_blank",
        href: documentationUrl
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.enterpriseSearch.workplaceSearch.customSourceDeployment.documentationLinkLabel",
        defaultMessage: "{name} connector documentation",
        values: {
          name
        }
      }))
    }
  })) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    "data-test-subj": "GenericDocumentationLink",
    id: "xpack.enterpriseSearch.workplaceSearch.customSourceDeployment.genericDocumentationHelpText",
    defaultMessage: "Review the {documentationLink} to learn how to build and deploy your own connector on the self managed infrastructure of your choice.",
    values: {
      documentationLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        target: "_blank",
        href: documentationUrl
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.enterpriseSearch.workplaceSearch.customSourceDeployment.genericDocumentationLabel",
        defaultMessage: "Custom API source documentation"
      }))
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.enterpriseSearch.workplaceSearch.customSourceDeployment.sourceIdentifierHelpText",
    defaultMessage: "Specify the following Source Identifier along with an {apiKeyLink} in the deployed connector's config file to sync documents.",
    values: {
      apiKeyLink: /*#__PURE__*/_react.default.createElement(_react_router_helpers.EuiLinkTo, {
        target: "_blank",
        to: _routes.API_KEYS_PATH
      }, _constants.API_KEY_LABEL)
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: small ? 's' : 'l'
  }), /*#__PURE__*/_react.default.createElement(_source_identifier.SourceIdentifier, {
    id: id
  }));
};
exports.CustomSourceDeployment = CustomSourceDeployment;