"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AddCustomSourceSteps = exports.AddCustomSourceLogic = void 0;
var _kea = require("kea");
var _api = require("../../../../../../../../common/types/api");
var _add_custom_source_api_logic = require("./add_custom_source_api_logic");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
let AddCustomSourceSteps = exports.AddCustomSourceSteps = /*#__PURE__*/function (AddCustomSourceSteps) {
  AddCustomSourceSteps["ConfigureCustomStep"] = "Configure Custom";
  AddCustomSourceSteps["SaveCustomStep"] = "Save Custom";
  return AddCustomSourceSteps;
}({});
/**
 * Workplace Search needs to know the host for the redirect. As of yet, we do not
 * have access to this in Kibana. We parse it from the browser and pass it as a param.
 */

const AddCustomSourceLogic = exports.AddCustomSourceLogic = (0, _kea.kea)({
  connect: {
    actions: [_add_custom_source_api_logic.AddCustomSourceApiLogic, ['makeRequest', 'apiError', 'apiSuccess']],
    values: [_add_custom_source_api_logic.AddCustomSourceApiLogic, ['status']]
  },
  path: ['enterprise_search', 'workplace_search', 'add_custom_source_logic'],
  actions: {
    createContentSource: true,
    setCustomSourceNameValue: customSourceNameValue => customSourceNameValue,
    setNewCustomSource: data => data
  },
  reducers: ({
    props
  }) => ({
    buttonLoading: [false, {
      createContentSource: () => true,
      apiSuccess: () => false,
      apiError: () => false
    }],
    currentStep: [AddCustomSourceSteps.ConfigureCustomStep, {
      setNewCustomSource: () => AddCustomSourceSteps.SaveCustomStep
    }],
    customSourceNameValue: [props.initialValue || '', {
      // @ts-expect-error upgrade typescript v5.1.6
      setCustomSourceNameValue: (_, customSourceNameValue) => customSourceNameValue
    }],
    newCustomSource: [{}, {
      // @ts-expect-error upgrade typescript v5.1.6
      setNewCustomSource: (_, newCustomSource) => newCustomSource
    }]
  }),
  listeners: ({
    actions,
    values,
    props
  }) => ({
    createContentSource: () => {
      const {
        customSourceNameValue
      } = values;
      const {
        baseServiceType
      } = props;
      actions.makeRequest({
        name: customSourceNameValue,
        baseServiceType
      });
    },
    apiSuccess: ({
      source
    }) => {
      actions.setNewCustomSource(source);
    }
  }),
  selectors: {
    buttonLoading: [selectors => [selectors.status], status => status === _api.Status.LOADING]
  }
});