"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ReorderableTable = void 0;
var _react = _interopRequireDefault(require("react"));
var _classnames = _interopRequireDefault(require("classnames"));
require("./reorderable_table.scss");
var _eui = require("@elastic/eui");
var _body_row = require("./body_row");
var _body_rows = require("./body_rows");
var _draggable_body_row = require("./draggable_body_row");
var _draggable_body_rows = require("./draggable_body_rows");
var _header_row = require("./header_row");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ReorderableTable = ({
  columns,
  items,
  noItemsMessage,
  unreorderableItems = [],
  bottomRows = [],
  className = '',
  disableDragging = false,
  disableReordering = false,
  onReorder = () => undefined,
  rowProps = () => ({}),
  rowErrors = () => undefined,
  showRowIndex = false
}) => {
  return /*#__PURE__*/_react.default.createElement("div", {
    className: (0, _classnames.default)(className, 'reorderableTable')
  }, /*#__PURE__*/_react.default.createElement(_header_row.HeaderRow, {
    columns: columns,
    leftAction: disableReordering ? undefined : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null),
    spacingForRowIdentifier: showRowIndex
  }), items.length === 0 && unreorderableItems.length === 0 && bottomRows.length === 0 && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    justifyContent: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": "NoItems",
    className: "reorderableTableNoItems"
  }, noItemsMessage)), items.length > 0 && disableReordering && /*#__PURE__*/_react.default.createElement(_body_rows.BodyRows, {
    items: items,
    renderItem: (item, itemIndex) => /*#__PURE__*/_react.default.createElement(_body_row.BodyRow, {
      key: `table_draggable_row_${itemIndex}`,
      columns: columns,
      item: item,
      additionalProps: rowProps(item),
      errors: rowErrors(item),
      rowIdentifier: showRowIndex ? `${itemIndex + 1}` : undefined
    })
  }), items.length > 0 && !disableReordering && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_draggable_body_rows.DraggableBodyRows, {
    items: items,
    renderItem: (item, itemIndex) => /*#__PURE__*/_react.default.createElement(_draggable_body_row.DraggableBodyRow, {
      key: `table_draggable_row_${itemIndex}`,
      columns: columns,
      item: item,
      additionalProps: rowProps(item),
      disableDragging: disableDragging,
      rowIndex: itemIndex,
      errors: rowErrors(item),
      rowIdentifier: showRowIndex ? `${itemIndex + 1}` : undefined
    }),
    onReorder: onReorder
  })), /*#__PURE__*/_react.default.createElement("div", {
    className: "unorderableRows"
  }, unreorderableItems.length > 0 && /*#__PURE__*/_react.default.createElement(_body_rows.BodyRows, {
    items: unreorderableItems,
    renderItem: (item, itemIndex) => /*#__PURE__*/_react.default.createElement(_body_row.BodyRow, {
      key: `table_draggable_row_${itemIndex}`,
      columns: columns,
      item: item,
      additionalProps: rowProps(item),
      errors: rowErrors(item),
      leftAction: disableReordering ? undefined : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, " "),
      rowIdentifier: showRowIndex ? '∞' : undefined
    })
  }), bottomRows.map((row, rowIndex) => /*#__PURE__*/_react.default.createElement(_body_row.BodyRow // Shoving a generic ReactNode into a BodyRow is kind of a hack
  , {
    key: rowIndex,
    rowIdentifier: showRowIndex ? '∞' : undefined,
    columns: [{
      render: () => row
    }],
    item: {},
    leftAction: disableReordering ? undefined : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, " "),
    "data-test-subj": "BottomRow"
  }))));
};
exports.ReorderableTable = ReorderableTable;