"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SimplifiedSelectable = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SimplifiedSelectable = ({
  emptyMessage,
  options,
  selectedOptions,
  onChange
}) => {
  const selectedOptionsMap = selectedOptions.reduce((acc, selectedOption) => ({
    ...acc,
    [selectedOption]: true
  }), {});
  const selectableOptions = options.map(option => ({
    label: option,
    checked: selectedOptionsMap[option] ? 'on' : undefined
  }));
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexEnd",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "SelectAllButton",
    iconType: "check",
    onClick: () => onChange(options),
    disabled: selectedOptions.length === options.length
  }, _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.crawler.simplifiedSelectable.selectAllButtonLabel', {
    defaultMessage: 'Select all'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "DeselectAllButton",
    iconType: "cross",
    onClick: () => onChange([]),
    disabled: selectedOptions.length === 0
  }, _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.crawler.simplifiedSelectable.deselectAllButtonLabel', {
    defaultMessage: 'Deselect all'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSelectable, {
    searchable: true,
    options: selectableOptions,
    listProps: {
      bordered: true
    },
    onChange: newSelectableOptions => {
      onChange(newSelectableOptions.filter(option => option.checked).map(option => option.label));
    },
    emptyMessage: emptyMessage
  }, (list, search) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, search, list)));
};
exports.SimplifiedSelectable = SimplifiedSelectable;