"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SchemaErrorsAccordion = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _react_router_helpers = require("../../react_router_helpers");
var _truncate = require("../../truncate");
var _constants = require("./constants");
require("./schema_errors_accordion.scss");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SchemaErrorsAccordion = ({
  fieldCoercionErrors,
  schema,
  generateViewPath
}) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, Object.keys(fieldCoercionErrors).map(fieldName => {
  const fieldType = schema[fieldName];
  const errors = fieldCoercionErrors[fieldName];
  const accordionHeader = /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    justifyContent: "spaceBetween",
    gutterSize: "xl",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement("strong", null, /*#__PURE__*/_react.default.createElement(_truncate.TruncatedContent, {
    content: fieldName,
    length: 32
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true
  }, /*#__PURE__*/_react.default.createElement("code", null, fieldType)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "euiButton euiButton--primary euiButton--small"
  }, _constants.ERROR_TABLE_REVIEW_CONTROL)));
  return /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    key: fieldName,
    id: `schemaErrorAccordion-${fieldName}`,
    className: "schemaErrorsAccordion",
    borders: "horizontal",
    buttonProps: {
      paddingSize: 'm'
    },
    buttonContent: accordionHeader
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTable, {
    tableLayout: "auto"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTableHeader, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTableHeaderCell, null, _constants.ERROR_TABLE_ID_HEADER), /*#__PURE__*/_react.default.createElement(_eui.EuiTableHeaderCell, null, _constants.ERROR_TABLE_ERROR_HEADER), generateViewPath && /*#__PURE__*/_react.default.createElement(_eui.EuiTableHeaderCell, {
    "aria-hidden": true
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiTableBody, null, errors.map(error => {
    const {
      id,
      error: errorMessage
    } = error;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiTableRow, {
      key: `schemaErrorDocument-${fieldName}-${id}`
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTableRowCell, {
      truncateText: true
    }, /*#__PURE__*/_react.default.createElement(_truncate.TruncatedContent, {
      tooltipType: "title",
      content: id,
      length: 22
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiTableRowCell, null, errorMessage), generateViewPath && /*#__PURE__*/_react.default.createElement(_eui.EuiTableRowCell, null, /*#__PURE__*/_react.default.createElement(_react_router_helpers.EuiLinkTo, {
      to: generateViewPath(id)
    }, _constants.ERROR_TABLE_VIEW_LINK)));
  }))));
}));
exports.SchemaErrorsAccordion = SchemaErrorsAccordion;