"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HiddenText = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const HiddenText = ({
  text,
  children
}) => {
  const [isHidden, toggleIsHidden] = (0, _react.useState)(true);
  const hiddenLabel = _i18n.i18n.translate('xpack.enterpriseSearch.hiddenText', {
    defaultMessage: 'Hidden text'
  });
  const hiddenText = isHidden ? /*#__PURE__*/_react.default.createElement("span", {
    "aria-label": hiddenLabel
  }, /*#__PURE__*/_react.default.createElement("span", {
    "aria-hidden": true
  }, text.replace(/./g, '•'))) : text;
  return children({
    hiddenText,
    isHidden,
    toggle: () => toggleIsHidden(!isHidden)
  });
};
exports.HiddenText = HiddenText;